/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ConcurrentMap;
import java.util.zip.ZipEntry;
import org.gradle.api.internal.changedetection.state.ResourceHasher;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.snapshot.RegularFileSnapshot;

public class CachingResourceHasher
implements ResourceHasher {
    private final ResourceHasher delegate;
    private final HashCode delegateHash;
    private final ConcurrentMap<HashCode, HashCode> hashes;

    public CachingResourceHasher(ResourceHasher delegate, ConcurrentMap<HashCode, HashCode> hashes) {
        this.delegate = delegate;
        Hasher hasher = Hashing.newHasher();
        delegate.appendConfigurationToHasher(hasher);
        this.delegateHash = hasher.hash();
        this.hashes = hashes;
    }

    @Override
    public HashCode hash(ZipEntry zipEntry, InputStream zipInput) throws IOException {
        return this.delegate.hash(zipEntry, zipInput);
    }

    @Override
    public void appendConfigurationToHasher(Hasher hasher) {
        this.delegate.appendConfigurationToHasher(hasher);
    }

    @Override
    public HashCode hash(RegularFileSnapshot snapshot) {
        Hasher hasher = Hashing.newHasher();
        hasher.putHash(this.delegateHash);
        hasher.putHash(snapshot.getHash());
        HashCode hash = hasher.hash();
        return this.hashes.computeIfAbsent(hash, hashCode -> this.delegate.hash(snapshot));
    }
}

