/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.gradle.maven.extension.internal.dep.com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.gradle.api.internal.changedetection.state.ConfigurableNormalizer;
import org.gradle.api.internal.changedetection.state.RegularFileHasher;
import org.gradle.api.internal.changedetection.state.ResourceFilter;
import org.gradle.api.internal.changedetection.state.ResourceHasher;
import org.gradle.internal.Factory;
import org.gradle.internal.file.FilePathUtil;
import org.gradle.internal.file.FileType;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.impl.DefaultFileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.impl.NormalizedPathFingerprintCompareStrategy;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.snapshot.RegularFileSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarHasher
implements ConfigurableNormalizer,
RegularFileHasher {
    private static final Logger LOGGER = LoggerFactory.getLogger(JarHasher.class);
    private final ResourceHasher classpathResourceHasher;
    private final ResourceFilter classpathResourceFilter;

    public JarHasher(ResourceHasher classpathResourceHasher, ResourceFilter classpathResourceFilter) {
        this.classpathResourceHasher = classpathResourceHasher;
        this.classpathResourceFilter = classpathResourceFilter;
    }

    @Override
    public HashCode hash(RegularFileSnapshot fileSnapshot) {
        return this.hashJarContents(fileSnapshot);
    }

    @Override
    public void appendConfigurationToHasher(Hasher hasher) {
        hasher.putString(this.getClass().getName());
        this.classpathResourceHasher.appendConfigurationToHasher(hasher);
        this.classpathResourceFilter.appendConfigurationToHasher(hasher);
    }

    private HashCode hashJarContents(RegularFileSnapshot jarFileSnapshot) {
        try {
            List<FileSystemLocationFingerprint> fingerprints = this.fingerprintZipEntries(jarFileSnapshot.getAbsolutePath());
            if (fingerprints.isEmpty()) {
                return null;
            }
            Hasher hasher = Hashing.newHasher();
            NormalizedPathFingerprintCompareStrategy.appendSortedToHasher(hasher, fingerprints);
            return hasher.hash();
        }
        catch (Exception e2) {
            return this.hashMalformedZip(jarFileSnapshot, e2);
        }
    }

    private List<FileSystemLocationFingerprint> fingerprintZipEntries(String jarFile) throws IOException {
        try (InputStream fileInputStream = Files.newInputStream(Paths.get(jarFile, new String[0]), new OpenOption[0]);){
            List<FileSystemLocationFingerprint> list = this.fingerprintZipEntries(fileInputStream);
            return list;
        }
    }

    private List<FileSystemLocationFingerprint> fingerprintZipEntries(InputStream input) throws IOException {
        ZipEntry zipEntry;
        ArrayList<FileSystemLocationFingerprint> fingerprints = Lists.newArrayList();
        ZipInputStream zipInput = new ZipInputStream(input);
        a relativePathFactory = new a();
        while ((zipEntry = zipInput.getNextEntry()) != null) {
            relativePathFactory.a(zipEntry);
            if (zipEntry.isDirectory() || this.classpathResourceFilter.shouldBeIgnored(relativePathFactory)) continue;
            if (zipEntry.getName().endsWith(".jar")) {
                fingerprints.addAll(this.fingerprintZipEntries(zipInput));
                continue;
            }
            HashCode hash = this.classpathResourceHasher.hash(zipEntry, zipInput);
            if (hash == null) continue;
            fingerprints.add(new DefaultFileSystemLocationFingerprint(zipEntry.getName(), FileType.RegularFile, hash));
        }
        return fingerprints;
    }

    private HashCode hashMalformedZip(RegularFileSnapshot jarFileSnapshot, Exception e2) {
        LOGGER.debug("Malformed jar '{}' found on classpath. Falling back to full content hash instead of classpath hashing.", (Object)jarFileSnapshot.getName(), (Object)e2);
        return jarFileSnapshot.getHash();
    }

    private static class a
    implements Factory<String[]> {
        private ZipEntry a;

        private a() {
        }

        public String[] a() {
            return FilePathUtil.getPathSegments(this.a.getName());
        }

        public void a(ZipEntry zipEntry) {
            this.a = zipEntry;
        }

        @Override
        public /* synthetic */ Object create() {
            return this.a();
        }
    }
}

