/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.pattern;

import org.gradle.api.internal.file.pattern.PathMatcher;
import org.gradle.api.internal.file.pattern.PatternStep;

public class FixedStepPathMatcher
implements PathMatcher {
    private final PatternStep step;
    private final PathMatcher next;
    private final int minSegments;
    private final int maxSegments;

    public FixedStepPathMatcher(PatternStep step, PathMatcher next) {
        this.step = step;
        this.next = next;
        this.minSegments = 1 + next.getMinSegments();
        this.maxSegments = next.getMaxSegments() == Integer.MAX_VALUE ? Integer.MAX_VALUE : next.getMaxSegments() + 1;
    }

    public String toString() {
        return "{fixed-step: " + this.step + ", next: " + this.next + "}";
    }

    @Override
    public int getMinSegments() {
        return this.minSegments;
    }

    @Override
    public int getMaxSegments() {
        return this.maxSegments;
    }

    @Override
    public boolean matches(String[] segments, int startIndex) {
        int remaining = segments.length - startIndex;
        if (remaining < this.minSegments || remaining > this.maxSegments) {
            return false;
        }
        if (!this.step.matches(segments[startIndex])) {
            return false;
        }
        return this.next.matches(segments, startIndex + 1);
    }
}

