/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.controller;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.UncheckedIOException;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.internal.controller.BuildCacheController;
import org.gradle.caching.internal.controller.BuildCacheLoadCommand;
import org.gradle.caching.internal.controller.BuildCacheStoreCommand;
import org.gradle.caching.internal.controller.service.BuildCacheServiceHandle;
import org.gradle.caching.internal.controller.service.BuildCacheServiceHandleFactory;
import org.gradle.caching.internal.controller.service.BuildCacheServiceRole;
import org.gradle.caching.internal.controller.service.BuildCacheServicesConfiguration;
import org.gradle.caching.internal.controller.service.LoadTarget;
import org.gradle.caching.internal.controller.service.LocalBuildCacheServiceHandle;
import org.gradle.caching.internal.controller.service.NullBuildCacheServiceHandle;
import org.gradle.caching.internal.controller.service.NullLocalBuildCacheServiceHandle;
import org.gradle.caching.internal.controller.service.StoreTarget;
import org.gradle.caching.internal.packaging.UnrecoverableUnpackingException;
import org.gradle.caching.local.internal.BuildCacheTempFileStore;
import org.gradle.caching.local.internal.DefaultBuildCacheTempFileStore;
import org.gradle.caching.local.internal.LocalBuildCacheService;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.CompositeStoppable;

public class DefaultBuildCacheController
implements BuildCacheController {
    final BuildCacheServiceHandle legacyLocal;
    final BuildCacheServiceHandle remote;
    final LocalBuildCacheServiceHandle local;
    private final BuildCacheTempFileStore tmp;
    private final boolean emitDebugLogging;
    private boolean closed;

    public DefaultBuildCacheController(BuildCacheServicesConfiguration config, BuildCacheServiceHandleFactory handleFactory, File gradleUserHomeDir, boolean logStackTraces, boolean emitDebugLogging) {
        this.emitDebugLogging = emitDebugLogging;
        if (config.local instanceof LocalBuildCacheService) {
            LocalBuildCacheService castLocal = (LocalBuildCacheService)((Object)config.local);
            this.local = handleFactory.toHandle(castLocal, config.localPush, logStackTraces);
            this.tmp = castLocal;
            this.legacyLocal = NullBuildCacheServiceHandle.INSTANCE;
        } else {
            this.local = NullLocalBuildCacheServiceHandle.INSTANCE;
            this.legacyLocal = handleFactory.toHandle(config.local, config.localPush, BuildCacheServiceRole.LOCAL, logStackTraces);
            this.tmp = new DefaultBuildCacheTempFileStore(new File(gradleUserHomeDir, "build-cache-tmp"));
        }
        this.remote = handleFactory.toHandle(config.remote, config.remotePush, BuildCacheServiceRole.REMOTE, logStackTraces);
    }

    @Override
    public <T> T load(final BuildCacheLoadCommand<T> command) {
        BuildCacheLoadCommand.Result result;
        final b unpack = new b(command);
        if (this.local.canLoad()) {
            try {
                this.local.load(command.getKey(), unpack);
            }
            catch (UnrecoverableUnpackingException e2) {
                throw e2;
            }
            catch (Exception e3) {
                throw new GradleException("Build cache entry " + command.getKey().getHashCode() + " from local build cache is invalid", e3);
            }
            if (unpack.c != null) {
                return unpack.c.getMetadata();
            }
        }
        if (this.legacyLocal.canLoad() || this.remote.canLoad()) {
            this.tmp.withTempFile(command.getKey(), (Action<? super File>)new Action<File>(){

                public void a(File file) {
                    LoadTarget loadTarget = new LoadTarget(file);
                    BuildCacheServiceRole loadedRole = null;
                    if (DefaultBuildCacheController.this.legacyLocal.canLoad()) {
                        loadedRole = BuildCacheServiceRole.LOCAL;
                        DefaultBuildCacheController.this.legacyLocal.load(command.getKey(), loadTarget);
                    }
                    if (DefaultBuildCacheController.this.remote.canLoad() && !loadTarget.isLoaded()) {
                        loadedRole = BuildCacheServiceRole.REMOTE;
                        DefaultBuildCacheController.this.remote.load(command.getKey(), loadTarget);
                    }
                    if (loadTarget.isLoaded()) {
                        try {
                            unpack.a(file);
                        }
                        catch (UnrecoverableUnpackingException e2) {
                            throw e2;
                        }
                        catch (Exception e3) {
                            String roleDisplayName = loadedRole.getDisplayName();
                            throw new GradleException("Build cache entry " + command.getKey().getHashCode() + " from " + roleDisplayName + " build cache is invalid", e3);
                        }
                        if (DefaultBuildCacheController.this.local.canStore()) {
                            DefaultBuildCacheController.this.local.store(command.getKey(), file);
                        }
                    }
                }

                @Override
                public /* synthetic */ void execute(Object object) {
                    this.a((File)object);
                }
            });
        }
        if ((result = unpack.c) == null) {
            return null;
        }
        return result.getMetadata();
    }

    @Override
    public void store(BuildCacheStoreCommand command) {
        boolean anyStore;
        boolean bl = anyStore = this.local.canStore() || this.legacyLocal.canStore() || this.remote.canStore();
        if (!anyStore) {
            return;
        }
        final BuildCacheKey key = command.getKey();
        final a pack = new a(command);
        this.tmp.withTempFile(command.getKey(), (Action<? super File>)new Action<File>(){

            public void a(File file) {
                pack.a(file);
                if (DefaultBuildCacheController.this.legacyLocal.canStore()) {
                    DefaultBuildCacheController.this.legacyLocal.store(key, new StoreTarget(file));
                }
                if (DefaultBuildCacheController.this.remote.canStore()) {
                    DefaultBuildCacheController.this.remote.store(key, new StoreTarget(file));
                }
                if (DefaultBuildCacheController.this.local.canStore()) {
                    DefaultBuildCacheController.this.local.store(key, file);
                }
            }

            @Override
            public /* synthetic */ void execute(Object object) {
                this.a((File)object);
            }
        });
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            CompositeStoppable.stoppable(this.legacyLocal, this.local, this.remote).stop();
        }
    }

    private class a
    implements Action<File> {
        private final BuildCacheStoreCommand b;

        private a(BuildCacheStoreCommand command) {
            this.b = command;
        }

        public void a(File file) {
            try {
                BuildCacheStoreCommand.Result result = this.b.store(new FileOutputStream(file));
            }
            catch (IOException e2) {
                throw UncheckedException.throwAsUncheckedException(e2);
            }
        }

        @Override
        public /* synthetic */ void execute(Object object) {
            this.a((File)object);
        }
    }

    private class b<T>
    implements Action<File> {
        private final BuildCacheLoadCommand<T> b;
        private BuildCacheLoadCommand.Result<T> c;

        private b(BuildCacheLoadCommand<T> command) {
            this.b = command;
        }

        public void a(File file) {
            try (FileInputStream input = new FileInputStream(file);){
                this.c = this.b.load(input);
            }
            catch (IOException e2) {
                throw new UncheckedIOException(e2);
            }
        }

        @Override
        public /* synthetic */ void execute(Object object) {
            this.a((File)object);
        }
    }
}

