/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.http;

import com.gradle.maven.extension.internal.dep.com.google.common.cache.CacheBuilder;
import com.gradle.maven.extension.internal.dep.com.google.common.cache.CacheLoader;
import com.gradle.maven.extension.internal.dep.com.google.common.cache.LoadingCache;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableSet;
import com.gradle.maven.extension.internal.dep.org.apache.http.ssl.SSLInitializationException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.gradle.internal.resource.transport.http.SslContextFactory;

public class DefaultSslContextFactory
implements SslContextFactory {
    private static final char[] EMPTY_PASSWORD = "".toCharArray();
    private static final Set<String> SSL_SYSTEM_PROPERTIES = ImmutableSet.of("ssl.TrustManagerFactory.algorithm", "javax.net.ssl.trustStoreType", "javax.net.ssl.trustStore", "javax.net.ssl.trustStoreProvider", "javax.net.ssl.trustStorePassword", "ssl.KeyManagerFactory.algorithm", new String[]{"javax.net.ssl.keyStoreType", "javax.net.ssl.keyStore", "javax.net.ssl.keyStoreProvider", "javax.net.ssl.keyStorePassword"});
    private LoadingCache<Map<String, String>, SSLContext> cache = CacheBuilder.newBuilder().softValues().build(new a());

    @Override
    public SSLContext createSslContext() {
        return this.cache.getUnchecked(this.getCurrentProperties());
    }

    private Map<String, String> getCurrentProperties() {
        TreeMap<String, String> currentProperties = new TreeMap<String, String>();
        for (String prop : SSL_SYSTEM_PROPERTIES) {
            currentProperties.put(prop, System.getProperty(prop));
        }
        currentProperties.put("java.home", System.getProperty("java.home"));
        return currentProperties;
    }

    private static class a
    extends CacheLoader<Map<String, String>, SSLContext> {
        private a() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SSLContext a(Map<String, String> props) {
            try {
                String keyStoreType;
                TrustManagerFactory tmFactory;
                String trustStoreType;
                String trustAlgorithm = props.get("ssl.TrustManagerFactory.algorithm");
                if (trustAlgorithm == null) {
                    trustAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
                }
                if ((trustStoreType = props.get("javax.net.ssl.trustStoreType")) == null) {
                    trustStoreType = KeyStore.getDefaultType();
                }
                if ("none".equalsIgnoreCase(trustStoreType)) {
                    tmFactory = TrustManagerFactory.getInstance(trustAlgorithm);
                } else {
                    File trustStoreFile;
                    String s2 = props.get("javax.net.ssl.trustStore");
                    if (s2 != null) {
                        trustStoreFile = new File(s2);
                        tmFactory = TrustManagerFactory.getInstance(trustAlgorithm);
                        String trustStoreProvider = props.get("javax.net.ssl.trustStoreProvider");
                        KeyStore trustStore = trustStoreProvider != null ? KeyStore.getInstance(trustStoreType, trustStoreProvider) : KeyStore.getInstance(trustStoreType);
                        String trustStorePassword = props.get("javax.net.ssl.trustStorePassword");
                        try (FileInputStream instream = new FileInputStream(trustStoreFile);){
                            trustStore.load(instream, trustStorePassword != null ? trustStorePassword.toCharArray() : null);
                        }
                        tmFactory.init(trustStore);
                    } else {
                        File javaHome = new File(props.get("java.home"));
                        File file = new File(javaHome, "lib/security/jssecacerts");
                        trustStoreFile = !file.exists() ? (file = new File(javaHome, "lib/security/cacerts")) : file;
                        tmFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
                        String trustStorePassword = props.get("javax.net.ssl.trustStorePassword");
                        try (FileInputStream instream = new FileInputStream(trustStoreFile);){
                            trustStore.load(instream, trustStorePassword != null ? trustStorePassword.toCharArray() : null);
                        }
                        tmFactory.init(trustStore);
                    }
                }
                KeyManagerFactory kmFactory = null;
                String keyAlgorithm = props.get("ssl.KeyManagerFactory.algorithm");
                if (keyAlgorithm == null) {
                    keyAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
                }
                if ((keyStoreType = props.get("javax.net.ssl.keyStoreType")) == null) {
                    keyStoreType = KeyStore.getDefaultType();
                }
                if ("none".equalsIgnoreCase(keyStoreType)) {
                    kmFactory = KeyManagerFactory.getInstance(keyAlgorithm);
                } else {
                    File keyStoreFile = null;
                    String s3 = props.get("javax.net.ssl.keyStore");
                    if (s3 != null) {
                        keyStoreFile = new File(s3);
                    }
                    if (keyStoreFile != null) {
                        kmFactory = KeyManagerFactory.getInstance(keyAlgorithm);
                        String keyStoreProvider = props.get("javax.net.ssl.keyStoreProvider");
                        KeyStore keyStore = keyStoreProvider != null ? KeyStore.getInstance(keyStoreType, keyStoreProvider) : KeyStore.getInstance(keyStoreType);
                        String keyStorePassword = props.get("javax.net.ssl.keyStorePassword");
                        try (FileInputStream instream = new FileInputStream(keyStoreFile);){
                            keyStore.load(instream, keyStorePassword != null ? keyStorePassword.toCharArray() : EMPTY_PASSWORD);
                        }
                        kmFactory.init(keyStore, keyStorePassword != null ? keyStorePassword.toCharArray() : EMPTY_PASSWORD);
                    }
                }
                SSLContext sslcontext = SSLContext.getInstance("TLS");
                sslcontext.init(kmFactory != null ? kmFactory.getKeyManagers() : null, tmFactory != null ? tmFactory.getTrustManagers() : null, null);
                return sslcontext;
            }
            catch (GeneralSecurityException e2) {
                throw new SSLInitializationException(e2.getMessage(), e2);
            }
            catch (IOException e3) {
                throw new SSLInitializationException(e3.getMessage(), e3);
            }
        }

        @Override
        public /* synthetic */ Object load(Object object) throws Exception {
            return this.a((Map)object);
        }
    }
}

