/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.lang3;

import com.gradle.maven.extension.internal.dep.org.apache.commons.lang3.ArrayUtils;
import java.util.ArrayList;

public class StringUtils {
    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i2 = 0; i2 < strLen; ++i2) {
            if (Character.isWhitespace(cs.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static String substringBefore(String str, String separator) {
        if (StringUtils.isEmpty(str) || separator == null) {
            return str;
        }
        if (separator.isEmpty()) {
            return "";
        }
        int pos = str.indexOf(separator);
        if (pos == -1) {
            return str;
        }
        return str.substring(0, pos);
    }

    public static String[] split(String str, char separatorChar) {
        return StringUtils.splitWorker(str, separatorChar, false);
    }

    public static String[] split(String str, String separatorChars) {
        return StringUtils.splitWorker(str, separatorChars, -1, false);
    }

    public static String[] split(String str, String separatorChars, int max) {
        return StringUtils.splitWorker(str, separatorChars, max, false);
    }

    private static String[] splitWorker(String str, char separatorChar, boolean preserveAllTokens) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> list = new ArrayList<String>();
        int i2 = 0;
        int start = 0;
        boolean match = false;
        boolean lastMatch = false;
        while (i2 < len) {
            if (str.charAt(i2) == separatorChar) {
                if (match || preserveAllTokens) {
                    list.add(str.substring(start, i2));
                    match = false;
                    lastMatch = true;
                }
                start = ++i2;
                continue;
            }
            lastMatch = false;
            match = true;
            ++i2;
        }
        if (match || preserveAllTokens && lastMatch) {
            list.add(str.substring(start, i2));
        }
        return list.toArray(new String[list.size()]);
    }

    private static String[] splitWorker(String str, String separatorChars, int max, boolean preserveAllTokens) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> list = new ArrayList<String>();
        int sizePlus1 = 1;
        int i2 = 0;
        int start = 0;
        boolean match = false;
        boolean lastMatch = false;
        if (separatorChars == null) {
            while (i2 < len) {
                if (Character.isWhitespace(str.charAt(i2))) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i2 = len;
                            lastMatch = false;
                        }
                        list.add(str.substring(start, i2));
                        match = false;
                    }
                    start = ++i2;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i2;
            }
        } else if (separatorChars.length() == 1) {
            char sep = separatorChars.charAt(0);
            while (i2 < len) {
                if (str.charAt(i2) == sep) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i2 = len;
                            lastMatch = false;
                        }
                        list.add(str.substring(start, i2));
                        match = false;
                    }
                    start = ++i2;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i2;
            }
        } else {
            while (i2 < len) {
                if (separatorChars.indexOf(str.charAt(i2)) >= 0) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i2 = len;
                            lastMatch = false;
                        }
                        list.add(str.substring(start, i2));
                        match = false;
                    }
                    start = ++i2;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i2;
            }
        }
        if (match || preserveAllTokens && lastMatch) {
            list.add(str.substring(start, i2));
        }
        return list.toArray(new String[list.size()]);
    }

    public static String repeat(String str, int repeat) {
        if (str == null) {
            return null;
        }
        if (repeat <= 0) {
            return "";
        }
        int inputLength = str.length();
        if (repeat == 1 || inputLength == 0) {
            return str;
        }
        if (inputLength == 1 && repeat <= 8192) {
            return StringUtils.repeat(str.charAt(0), repeat);
        }
        int outputLength = inputLength * repeat;
        switch (inputLength) {
            case 1: {
                return StringUtils.repeat(str.charAt(0), repeat);
            }
            case 2: {
                char ch0 = str.charAt(0);
                char ch1 = str.charAt(1);
                char[] output2 = new char[outputLength];
                for (int i2 = repeat * 2 - 2; i2 >= 0; --i2) {
                    output2[i2] = ch0;
                    output2[i2 + 1] = ch1;
                    --i2;
                }
                return new String(output2);
            }
        }
        StringBuilder buf = new StringBuilder(outputLength);
        for (int i3 = 0; i3 < repeat; ++i3) {
            buf.append(str);
        }
        return buf.toString();
    }

    public static String repeat(char ch, int repeat) {
        if (repeat <= 0) {
            return "";
        }
        char[] buf = new char[repeat];
        for (int i2 = repeat - 1; i2 >= 0; --i2) {
            buf[i2] = ch;
        }
        return new String(buf);
    }

    public static String leftPad(String str, int size, char padChar) {
        if (str == null) {
            return null;
        }
        int pads = size - str.length();
        if (pads <= 0) {
            return str;
        }
        if (pads > 8192) {
            return StringUtils.leftPad(str, size, String.valueOf(padChar));
        }
        return StringUtils.repeat(padChar, pads).concat(str);
    }

    public static String leftPad(String str, int size, String padStr) {
        if (str == null) {
            return null;
        }
        if (StringUtils.isEmpty(padStr)) {
            padStr = " ";
        }
        int padLen = padStr.length();
        int strLen = str.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str;
        }
        if (padLen == 1 && pads <= 8192) {
            return StringUtils.leftPad(str, size, padStr.charAt(0));
        }
        if (pads == padLen) {
            return padStr.concat(str);
        }
        if (pads < padLen) {
            return padStr.substring(0, pads).concat(str);
        }
        char[] padding = new char[pads];
        char[] padChars = padStr.toCharArray();
        for (int i2 = 0; i2 < pads; ++i2) {
            padding[i2] = padChars[i2 % padLen];
        }
        return new String(padding).concat(str);
    }
}

