/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.gradle.maven.extension.internal.dep.com.google.common.io.ByteStreams;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.IOUtils;
import com.gradle.maven.extension.internal.dep.org.objectweb.asm.ClassReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.zip.ZipEntry;
import org.gradle.api.internal.changedetection.state.ResourceHasher;
import org.gradle.api.internal.tasks.compile.ApiClassExtractor;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.snapshot.RegularFileSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbiExtractingClasspathResourceHasher
implements ResourceHasher {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbiExtractingClasspathResourceHasher.class);

    private HashCode hashClassBytes(InputStream inputStream) throws IOException {
        byte[] signature;
        ClassReader reader;
        byte[] classBytes = ByteStreams.toByteArray(inputStream);
        ApiClassExtractor extractor = new ApiClassExtractor(Collections.emptySet());
        if (extractor.shouldExtractApiClassFrom(reader = new ClassReader(classBytes)) && (signature = extractor.extractApiClassFrom(reader)) != null) {
            return Hashing.hashBytes(signature);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashCode hash(RegularFileSnapshot fileSnapshot) {
        HashCode hashCode;
        if (!this.isClassFile(fileSnapshot.getName())) {
            return null;
        }
        Path path = Paths.get(fileSnapshot.getAbsolutePath(), new String[0]);
        InputStream inputStream = null;
        try {
            inputStream = Files.newInputStream(path, new OpenOption[0]);
            hashCode = this.hashClassBytes(inputStream);
        }
        catch (Exception e2) {
            HashCode hashCode2;
            try {
                LOGGER.debug("Malformed class file '{}' found on compile classpath. Falling back to full file hash instead of ABI hashing.", (Object)fileSnapshot.getName(), (Object)e2);
                hashCode2 = fileSnapshot.getHash();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
            IOUtils.closeQuietly(inputStream);
            return hashCode2;
        }
        IOUtils.closeQuietly(inputStream);
        return hashCode;
    }

    @Override
    public HashCode hash(ZipEntry zipEntry, InputStream zipInput) throws IOException {
        if (!this.isClassFile(zipEntry.getName())) {
            return null;
        }
        return this.hashClassBytes(zipInput);
    }

    private boolean isClassFile(String name) {
        return name.endsWith(".class");
    }

    @Override
    public void appendConfigurationToHasher(Hasher hasher) {
        hasher.putString(this.getClass().getName());
    }
}

