/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.pattern;

import org.gradle.api.internal.file.pattern.PathMatcher;

public class GreedyPathMatcher
implements PathMatcher {
    private final PathMatcher next;

    public GreedyPathMatcher(PathMatcher next) {
        this.next = next;
    }

    public String toString() {
        return "{greedy next: " + this.next + "}";
    }

    @Override
    public int getMaxSegments() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMinSegments() {
        return this.next.getMinSegments();
    }

    @Override
    public boolean matches(String[] segments, int startIndex) {
        int minPos = Math.max(startIndex, segments.length - this.next.getMaxSegments());
        for (int pos = segments.length - this.next.getMinSegments(); pos >= minPos; --pos) {
            if (!this.next.matches(segments, pos)) continue;
            return true;
        }
        return false;
    }
}

