/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.packaging.impl;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PermissionUtils {
    private static Map<PosixFilePermission, Integer> posixPermissionToInteger = new HashMap<PosixFilePermission, Integer>();
    private static final boolean IS_POSIX;

    public static Set<PosixFilePermission> permissions(int mode) {
        HashSet<PosixFilePermission> result = new HashSet<PosixFilePermission>();
        for (Map.Entry<PosixFilePermission, Integer> entry : posixPermissionToInteger.entrySet()) {
            if ((mode & entry.getValue()) == 0) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    public static int permissions(File f2) {
        if (f2 == null) {
            throw new NullPointerException("File is null.");
        }
        if (!f2.exists()) {
            throw new IllegalArgumentException("File " + f2 + " does not exist.");
        }
        return IS_POSIX ? PermissionUtils.posixPermissions(f2) : PermissionUtils.standardPermissions(f2);
    }

    private static int posixPermissions(File f2) {
        try {
            Set<PosixFilePermission> permissions = Files.getPosixFilePermissions(f2.toPath(), new LinkOption[0]);
            int number = 0;
            for (Map.Entry<PosixFilePermission, Integer> entry : posixPermissionToInteger.entrySet()) {
                if (!permissions.contains((Object)entry.getKey())) continue;
                number += entry.getValue().intValue();
            }
            return number;
        }
        catch (IOException e2) {
            throw new UncheckedIOException(e2);
        }
    }

    private static Set<a> readStandardPermissions(File f2) {
        HashSet<a> permissions = new HashSet<a>();
        if (f2.canExecute()) {
            permissions.add(a.EXECUTE);
        }
        if (f2.canWrite()) {
            permissions.add(a.WRITE);
        }
        if (f2.canRead()) {
            permissions.add(a.READ);
        }
        return permissions;
    }

    private static Integer standardPermissions(File f2) {
        int number = 0;
        Set<a> permissions = PermissionUtils.readStandardPermissions(f2);
        for (a permission : permissions) {
            number += permission.a;
        }
        return number;
    }

    static {
        posixPermissionToInteger.put(PosixFilePermission.OWNER_EXECUTE, 64);
        posixPermissionToInteger.put(PosixFilePermission.OWNER_WRITE, 128);
        posixPermissionToInteger.put(PosixFilePermission.OWNER_READ, 256);
        posixPermissionToInteger.put(PosixFilePermission.GROUP_EXECUTE, 8);
        posixPermissionToInteger.put(PosixFilePermission.GROUP_WRITE, 16);
        posixPermissionToInteger.put(PosixFilePermission.GROUP_READ, 32);
        posixPermissionToInteger.put(PosixFilePermission.OTHERS_EXECUTE, 1);
        posixPermissionToInteger.put(PosixFilePermission.OTHERS_WRITE, 2);
        posixPermissionToInteger.put(PosixFilePermission.OTHERS_READ, 4);
        IS_POSIX = FileSystems.getDefault().supportedFileAttributeViews().contains("posix");
    }

    private static enum a {
        EXECUTE(72),
        WRITE(144),
        READ(288);

        private int a;

        private a(int mode) {
            this.a = mode;
        }
    }
}

