/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Comparator;

public class FileUtils {
    private static final Comparator<File> FILE_SEGMENT_COMPARATOR = new Comparator<File>(){

        public int a(File left, File right) {
            String leftPath = left.getPath();
            String rightPath = right.getPath();
            int len1 = leftPath.length();
            int len2 = rightPath.length();
            int lim = Math.min(len1, len2);
            for (int k2 = 0; k2 < lim; ++k2) {
                char c2;
                char c1 = leftPath.charAt(k2);
                if (c1 == (c2 = rightPath.charAt(k2))) continue;
                if (c1 == File.separatorChar) {
                    return -1;
                }
                if (c2 == File.separatorChar) {
                    return 1;
                }
                return c1 - c2;
            }
            return len1 - len2;
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.a((File)object, (File)object2);
        }
    };

    public static boolean hasExtensionIgnoresCase(String fileName, String extension) {
        return FileUtils.endsWithIgnoreCase(fileName, extension);
    }

    private static boolean endsWithIgnoreCase(String subject, String suffix) {
        return subject.regionMatches(true, subject.length() - suffix.length(), suffix, 0, suffix.length());
    }

    public static String withExtension(String filePath, String extension) {
        if (filePath.toLowerCase().endsWith(extension)) {
            return filePath;
        }
        return FileUtils.removeExtension(filePath) + extension;
    }

    public static String removeExtension(String filePath) {
        int fileNameStart = Math.max(filePath.lastIndexOf(47), filePath.lastIndexOf(92));
        int extensionPos = filePath.lastIndexOf(46);
        if (extensionPos > fileNameStart) {
            return filePath.substring(0, extensionPos);
        }
        return filePath;
    }

    public static File canonicalize(File src) {
        try {
            return src.getCanonicalFile();
        }
        catch (IOException e2) {
            throw new UncheckedIOException(e2);
        }
    }
}

