/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.http.protocol;

import com.gradle.maven.extension.internal.dep.org.apache.http.HttpConnection;
import com.gradle.maven.extension.internal.dep.org.apache.http.HttpHost;
import com.gradle.maven.extension.internal.dep.org.apache.http.HttpRequest;
import com.gradle.maven.extension.internal.dep.org.apache.http.protocol.BasicHttpContext;
import com.gradle.maven.extension.internal.dep.org.apache.http.protocol.HttpContext;
import com.gradle.maven.extension.internal.dep.org.apache.http.util.Args;

public class HttpCoreContext
implements HttpContext {
    private final HttpContext context;

    public static HttpCoreContext adapt(HttpContext context) {
        Args.notNull(context, "HTTP context");
        if (context instanceof HttpCoreContext) {
            return (HttpCoreContext)context;
        }
        return new HttpCoreContext(context);
    }

    public HttpCoreContext(HttpContext context) {
        this.context = context;
    }

    public HttpCoreContext() {
        this.context = new BasicHttpContext();
    }

    @Override
    public Object getAttribute(String id) {
        return this.context.getAttribute(id);
    }

    @Override
    public void setAttribute(String id, Object obj) {
        this.context.setAttribute(id, obj);
    }

    @Override
    public Object removeAttribute(String id) {
        return this.context.removeAttribute(id);
    }

    public <T> T getAttribute(String attribname, Class<T> clazz) {
        Args.notNull(clazz, "Attribute class");
        Object obj = this.getAttribute(attribname);
        if (obj == null) {
            return null;
        }
        return clazz.cast(obj);
    }

    public HttpConnection getConnection() {
        return this.getAttribute("http.connection", HttpConnection.class);
    }

    public HttpRequest getRequest() {
        return this.getAttribute("http.request", HttpRequest.class);
    }

    public boolean isRequestSent() {
        Boolean b2 = this.getAttribute("http.request_sent", Boolean.class);
        return b2 != null && b2 != false;
    }

    public HttpHost getTargetHost() {
        return this.getAttribute("http.target_host", HttpHost.class);
    }
}

