/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.http.util;

import com.gradle.maven.extension.internal.dep.org.apache.http.util.Args;
import com.gradle.maven.extension.internal.dep.org.apache.http.util.CharArrayBuffer;
import java.io.Serializable;

public final class ByteArrayBuffer
implements Serializable {
    private byte[] buffer;
    private int len;

    public ByteArrayBuffer(int capacity) {
        Args.notNegative(capacity, "Buffer capacity");
        this.buffer = new byte[capacity];
    }

    private void expand(int newlen) {
        byte[] newbuffer = new byte[Math.max(this.buffer.length << 1, newlen)];
        System.arraycopy(this.buffer, 0, newbuffer, 0, this.len);
        this.buffer = newbuffer;
    }

    public void append(byte[] b2, int off, int len) {
        if (b2 == null) {
            return;
        }
        if (off < 0 || off > b2.length || len < 0 || off + len < 0 || off + len > b2.length) {
            throw new IndexOutOfBoundsException("off: " + off + " len: " + len + " b.length: " + b2.length);
        }
        if (len == 0) {
            return;
        }
        int newlen = this.len + len;
        if (newlen > this.buffer.length) {
            this.expand(newlen);
        }
        System.arraycopy(b2, off, this.buffer, this.len, len);
        this.len = newlen;
    }

    public void append(int b2) {
        int newlen = this.len + 1;
        if (newlen > this.buffer.length) {
            this.expand(newlen);
        }
        this.buffer[this.len] = (byte)b2;
        this.len = newlen;
    }

    public void append(char[] b2, int off, int len) {
        if (b2 == null) {
            return;
        }
        if (off < 0 || off > b2.length || len < 0 || off + len < 0 || off + len > b2.length) {
            throw new IndexOutOfBoundsException("off: " + off + " len: " + len + " b.length: " + b2.length);
        }
        if (len == 0) {
            return;
        }
        int oldlen = this.len;
        int newlen = oldlen + len;
        if (newlen > this.buffer.length) {
            this.expand(newlen);
        }
        int i1 = off;
        for (int i2 = oldlen; i2 < newlen; ++i2) {
            this.buffer[i2] = (byte)b2[i1];
            ++i1;
        }
        this.len = newlen;
    }

    public void append(CharArrayBuffer b2, int off, int len) {
        if (b2 == null) {
            return;
        }
        this.append(b2.buffer(), off, len);
    }

    public void clear() {
        this.len = 0;
    }

    public int byteAt(int i2) {
        return this.buffer[i2];
    }

    public int capacity() {
        return this.buffer.length;
    }

    public int length() {
        return this.len;
    }

    public byte[] buffer() {
        return this.buffer;
    }

    public boolean isEmpty() {
        return this.len == 0;
    }

    public boolean isFull() {
        return this.len == this.buffer.length;
    }
}

