/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.command;

import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableSortedMap;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Map;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.internal.CacheableEntity;
import org.gradle.caching.internal.command.BuildCacheCommandFactory;
import org.gradle.caching.internal.command.BuildCacheLoadListener;
import org.gradle.caching.internal.controller.BuildCacheLoadCommand;
import org.gradle.caching.internal.controller.BuildCacheStoreCommand;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.caching.internal.origin.OriginMetadataFactory;
import org.gradle.caching.internal.packaging.BuildCacheEntryPacker;
import org.gradle.caching.internal.packaging.UnrecoverableUnpackingException;
import org.gradle.internal.file.FileType;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FingerprintingStrategy;
import org.gradle.internal.fingerprint.impl.AbsolutePathFingerprintingStrategy;
import org.gradle.internal.fingerprint.impl.DefaultCurrentFileCollectionFingerprint;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBuildCacheCommandFactory
implements BuildCacheCommandFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultBuildCacheCommandFactory.class);
    private BuildCacheEntryPacker packer;
    private OriginMetadataFactory originMetadataFactory;
    private StringInterner stringInterner;

    @Inject
    public DefaultBuildCacheCommandFactory(BuildCacheEntryPacker packer, OriginMetadataFactory originMetadataFactory, StringInterner stringInterner) {
        this.packer = packer;
        this.originMetadataFactory = originMetadataFactory;
        this.stringInterner = stringInterner;
    }

    @Override
    public BuildCacheLoadCommand<BuildCacheCommandFactory.LoadMetadata> createLoad(BuildCacheKey cacheKey, CacheableEntity entity, Iterable<File> localState, BuildCacheLoadListener loadListener) {
        return new a(cacheKey, entity, localState, loadListener);
    }

    @Override
    public BuildCacheStoreCommand createStore(BuildCacheKey cacheKey, CacheableEntity entity, Map<String, CurrentFileCollectionFingerprint> fingerprints, long executionTime) {
        return new b(cacheKey, entity, fingerprints, executionTime);
    }

    private class b
    implements BuildCacheStoreCommand {
        private final BuildCacheKey b;
        private final CacheableEntity c;
        private final Map<String, CurrentFileCollectionFingerprint> d;
        private final long e;

        private b(BuildCacheKey cacheKey, CacheableEntity entity, Map<String, CurrentFileCollectionFingerprint> fingerprints, long executionTime) {
            this.b = cacheKey;
            this.c = entity;
            this.d = fingerprints;
            this.e = executionTime;
        }

        @Override
        public BuildCacheKey getKey() {
            return this.b;
        }

        @Override
        public BuildCacheStoreCommand.Result store(OutputStream output) throws IOException {
            LOGGER.debug("Packing {}", (Object)this.c.getDisplayName());
            final BuildCacheEntryPacker.PackResult packResult = DefaultBuildCacheCommandFactory.this.packer.pack(this.c, this.d, output, DefaultBuildCacheCommandFactory.this.originMetadataFactory.createWriter(this.c, this.e));
            return new BuildCacheStoreCommand.Result(){

                @Override
                public long getArtifactEntryCount() {
                    return packResult.getEntries();
                }
            };
        }
    }

    private class a
    implements BuildCacheLoadCommand<BuildCacheCommandFactory.LoadMetadata> {
        private final BuildCacheKey b;
        private final CacheableEntity c;
        private final Iterable<File> d;
        private final BuildCacheLoadListener e;

        private a(BuildCacheKey cacheKey, CacheableEntity entity, Iterable<File> localState, BuildCacheLoadListener loadListener) {
            this.b = cacheKey;
            this.c = entity;
            this.d = localState;
            this.e = loadListener;
        }

        @Override
        public BuildCacheKey getKey() {
            return this.b;
        }

        @Override
        public BuildCacheLoadCommand.Result<BuildCacheCommandFactory.LoadMetadata> load(InputStream input) {
            this.e.beforeLoad();
            try {
                final BuildCacheEntryPacker.UnpackResult unpackResult = DefaultBuildCacheCommandFactory.this.packer.unpack(this.c, input, DefaultBuildCacheCommandFactory.this.originMetadataFactory.createReader(this.c));
                final ImmutableSortedMap<String, CurrentFileCollectionFingerprint> snapshots = this.a(unpackResult.getSnapshots());
                LOGGER.debug("Unpacked trees for {} from cache.", (Object)this.c.getDisplayName());
                BuildCacheLoadCommand.Result<BuildCacheCommandFactory.LoadMetadata> result = new BuildCacheLoadCommand.Result<BuildCacheCommandFactory.LoadMetadata>(){

                    @Override
                    public long getArtifactEntryCount() {
                        return unpackResult.getEntries();
                    }

                    public BuildCacheCommandFactory.LoadMetadata a() {
                        return new BuildCacheCommandFactory.LoadMetadata(){

                            @Override
                            public OriginMetadata getOriginMetadata() {
                                return unpackResult.getOriginMetadata();
                            }
                        };
                    }

                    @Override
                    public /* synthetic */ Object getMetadata() {
                        return this.a();
                    }
                };
                return result;
            }
            catch (UnrecoverableUnpackingException e2) {
                throw new UnrecoverableUnpackingException(String.format("Failed to unpack trees for %s", this.c.getDisplayName()), e2);
            }
            catch (Exception e3) {
                throw new GradleException(String.format("Failed to unpack trees for %s", this.c.getDisplayName()), e3);
            }
            finally {
                this.a();
            }
        }

        private ImmutableSortedMap<String, CurrentFileCollectionFingerprint> a(Map<String, ? extends FileSystemLocationSnapshot> treeSnapshots) {
            ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
            FingerprintingStrategy fingerprintingStrategy = AbsolutePathFingerprintingStrategy.IGNORE_MISSING;
            this.c.visitTrees((treeName, type, root) -> {
                if (root == null) {
                    builder.put(treeName, fingerprintingStrategy.getEmptyFingerprint());
                    return;
                }
                FileSystemLocationSnapshot treeSnapshot = (FileSystemLocationSnapshot)treeSnapshots.get(treeName);
                String internedAbsolutePath = DefaultBuildCacheCommandFactory.this.stringInterner.intern(root.getAbsolutePath());
                ArrayList<FileSystemSnapshot> roots = new ArrayList<FileSystemSnapshot>();
                if (treeSnapshot == null) {
                    builder.put(treeName, fingerprintingStrategy.getEmptyFingerprint());
                    return;
                }
                switch (type) {
                    case FILE: {
                        if (treeSnapshot.getType() != FileType.RegularFile) {
                            throw new IllegalStateException(String.format("Only a regular file should be produced by unpacking tree '%s', but saw a %s", new Object[]{treeName, treeSnapshot.getType()}));
                        }
                        roots.add(treeSnapshot);
                        break;
                    }
                    case DIRECTORY: {
                        roots.add(treeSnapshot);
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                builder.put(treeName, DefaultCurrentFileCollectionFingerprint.from(roots, fingerprintingStrategy));
            });
            return builder.build();
        }

        private void a() {
            for (File localStateFile : this.d) {
                try {
                    this.a(localStateFile);
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(String.format("Failed to clean up local state files for %s: %s", this.c.getDisplayName(), localStateFile), ex);
                }
            }
        }

        private void a(File file) throws IOException {
            if (file != null && file.exists()) {
                if (file.isDirectory()) {
                    FileUtils.cleanDirectory(file);
                } else {
                    FileUtils.forceDelete(file);
                }
            }
        }
    }
}

