/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot.impl;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.gradle.internal.snapshot.DirectorySnapshot;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshotVisitor;
import org.gradle.internal.snapshot.MerkleDirectorySnapshotBuilder;
import org.gradle.internal.snapshot.RelativePathSegmentsTracker;

public class FileSystemSnapshotFilter {
    public static FileSystemSnapshot filterSnapshot(final Predicate<FileSystemLocationSnapshot> spec, FileSystemSnapshot unfiltered) {
        final MerkleDirectorySnapshotBuilder builder = MerkleDirectorySnapshotBuilder.noSortingRequired();
        final AtomicBoolean hasBeenFiltered = new AtomicBoolean(false);
        unfiltered.accept(new FileSystemSnapshotVisitor(){
            private final RelativePathSegmentsTracker d = new RelativePathSegmentsTracker();

            @Override
            public boolean preVisitDirectory(DirectorySnapshot directorySnapshot) {
                boolean root = this.d.isRoot();
                this.d.enter(directorySnapshot);
                if (root || spec.test(directorySnapshot)) {
                    builder.preVisitDirectory(directorySnapshot);
                    return true;
                }
                hasBeenFiltered.set(true);
                this.d.leave();
                return false;
            }

            @Override
            public void visit(FileSystemLocationSnapshot fileSnapshot) {
                boolean root = this.d.isRoot();
                this.d.enter(fileSnapshot);
                if (root || spec.test(fileSnapshot)) {
                    builder.visit(fileSnapshot);
                } else {
                    hasBeenFiltered.set(true);
                }
                this.d.leave();
            }

            @Override
            public void postVisitDirectory(DirectorySnapshot directorySnapshot) {
                this.d.leave();
                builder.postVisitDirectory();
            }
        });
        if (builder.getResult() == null) {
            return FileSystemSnapshot.EMPTY;
        }
        return hasBeenFiltered.get() ? builder.getResult() : unfiltered;
    }
}

