/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.node;

import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonGenerator;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.type.WritableTypeId;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.SerializerProvider;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.node.BaseJsonNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.node.ContainerNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.node.JsonNodeType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ArrayNode
extends ContainerNode<ArrayNode> {
    private final List<JsonNode> _children = new ArrayList<JsonNode>();

    public ArrayNode(JsonNodeFactory nf) {
        super(nf);
    }

    @Override
    public boolean isEmpty(SerializerProvider serializers) {
        return this._children.isEmpty();
    }

    @Override
    public JsonNodeType getNodeType() {
        return JsonNodeType.ARRAY;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public JsonToken asToken() {
        return JsonToken.START_ARRAY;
    }

    @Override
    public int size() {
        return this._children.size();
    }

    @Override
    public Iterator<JsonNode> elements() {
        return this._children.iterator();
    }

    @Override
    public JsonNode get(int index) {
        if (index >= 0 && index < this._children.size()) {
            return this._children.get(index);
        }
        return null;
    }

    @Override
    public JsonNode get(String fieldName) {
        return null;
    }

    @Override
    public void serialize(JsonGenerator f2, SerializerProvider provider) throws IOException {
        List<JsonNode> c2 = this._children;
        int size = c2.size();
        f2.writeStartArray(size);
        for (int i2 = 0; i2 < size; ++i2) {
            JsonNode n2 = c2.get(i2);
            ((BaseJsonNode)n2).serialize(f2, provider);
        }
        f2.writeEndArray();
    }

    @Override
    public void serializeWithType(JsonGenerator g2, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g2, typeSer.typeId(this, JsonToken.START_ARRAY));
        for (JsonNode n2 : this._children) {
            ((BaseJsonNode)n2).serialize(g2, provider);
        }
        typeSer.writeTypeSuffix(g2, typeIdDef);
    }

    public ArrayNode add(JsonNode value) {
        if (value == null) {
            value = this.nullNode();
        }
        this._add(value);
        return this;
    }

    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (o2 == null) {
            return false;
        }
        if (o2 instanceof ArrayNode) {
            return this._children.equals(((ArrayNode)o2)._children);
        }
        return false;
    }

    public int hashCode() {
        return this._children.hashCode();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(16 + (this.size() << 4));
        sb.append('[');
        int len = this._children.size();
        for (int i2 = 0; i2 < len; ++i2) {
            if (i2 > 0) {
                sb.append(',');
            }
            sb.append(this._children.get(i2).toString());
        }
        sb.append(']');
        return sb.toString();
    }

    protected ArrayNode _add(JsonNode node) {
        this._children.add(node);
        return this;
    }
}

