/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.impl;

import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableMultimap;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Iterables;
import java.util.Map;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.FingerprintCompareStrategy;
import org.gradle.internal.fingerprint.FingerprintingStrategy;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.snapshot.DirectorySnapshot;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshotVisitor;

public class DefaultCurrentFileCollectionFingerprint
implements CurrentFileCollectionFingerprint {
    private final Map<String, FileSystemLocationFingerprint> fingerprints;
    private final FingerprintCompareStrategy compareStrategy;
    private final String identifier;
    private final Iterable<FileSystemSnapshot> roots;
    private final ImmutableMultimap<String, HashCode> rootHashes;
    private HashCode hash;

    public static CurrentFileCollectionFingerprint from(Iterable<FileSystemSnapshot> roots, FingerprintingStrategy strategy) {
        if (Iterables.isEmpty(roots)) {
            return strategy.getEmptyFingerprint();
        }
        Map<String, FileSystemLocationFingerprint> snapshots = strategy.collectFingerprints(roots);
        if (snapshots.isEmpty()) {
            return strategy.getEmptyFingerprint();
        }
        return new DefaultCurrentFileCollectionFingerprint(snapshots, strategy.getCompareStrategy(), strategy.getIdentifier(), roots);
    }

    private DefaultCurrentFileCollectionFingerprint(Map<String, FileSystemLocationFingerprint> fingerprints, FingerprintCompareStrategy compareStrategy, String identifier, Iterable<FileSystemSnapshot> roots) {
        this.fingerprints = fingerprints;
        this.compareStrategy = compareStrategy;
        this.identifier = identifier;
        this.roots = roots;
        final ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        this.accept(new FileSystemSnapshotVisitor(){

            @Override
            public boolean preVisitDirectory(DirectorySnapshot directorySnapshot) {
                builder.put(directorySnapshot.getAbsolutePath(), directorySnapshot.getHash());
                return false;
            }

            @Override
            public void visit(FileSystemLocationSnapshot fileSnapshot) {
                builder.put(fileSnapshot.getAbsolutePath(), fileSnapshot.getHash());
            }

            @Override
            public void postVisitDirectory(DirectorySnapshot directorySnapshot) {
            }
        });
        this.rootHashes = builder.build();
    }

    @Override
    public HashCode getHash() {
        if (this.hash == null) {
            Hasher hasher = Hashing.newHasher();
            this.compareStrategy.appendToHasher(hasher, this.fingerprints.values());
            this.hash = hasher.hash();
        }
        return this.hash;
    }

    @Override
    public Map<String, FileSystemLocationFingerprint> getFingerprints() {
        return this.fingerprints;
    }

    @Override
    public String getStrategyIdentifier() {
        return this.identifier;
    }

    @Override
    public void accept(FileSystemSnapshotVisitor visitor) {
        if (this.roots == null) {
            throw new UnsupportedOperationException("Roots not available.");
        }
        for (FileSystemSnapshot root : this.roots) {
            root.accept(visitor);
        }
    }
}

