/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.commons.io;

import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class Java7Support {
    private static final boolean IS_JAVA7;
    private static Method isSymbolicLink;
    private static Method delete;
    private static Method toPath;
    private static Method exists;
    private static Method toFile;
    private static Method readSymlink;
    private static Method createSymlink;
    private static Object emptyLinkOpts;
    private static Object emptyFileAttributes;

    public static boolean isSymLink(File file) {
        try {
            Object path = toPath.invoke((Object)file, new Object[0]);
            Boolean result = (Boolean)isSymbolicLink.invoke(null, path);
            return result;
        }
        catch (IllegalAccessException e2) {
            throw new RuntimeException(e2);
        }
        catch (InvocationTargetException e3) {
            throw new RuntimeException(e3);
        }
    }

    public static boolean isAtLeastJava7() {
        return IS_JAVA7;
    }

    static {
        boolean isJava7x = true;
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> files = cl.loadClass("java.nio.file.Files");
            Class<?> path = cl.loadClass("java.nio.file.Path");
            Class<?> fa = cl.loadClass("java.nio.file.attribute.FileAttribute");
            Class<?> linkOption = cl.loadClass("java.nio.file.LinkOption");
            isSymbolicLink = files.getMethod("isSymbolicLink", path);
            delete = files.getMethod("delete", path);
            readSymlink = files.getMethod("readSymbolicLink", path);
            emptyFileAttributes = Array.newInstance(fa, 0);
            createSymlink = files.getMethod("createSymbolicLink", path, path, emptyFileAttributes.getClass());
            emptyLinkOpts = Array.newInstance(linkOption, 0);
            exists = files.getMethod("exists", path, emptyLinkOpts.getClass());
            toPath = File.class.getMethod("toPath", new Class[0]);
            toFile = path.getMethod("toFile", new Class[0]);
        }
        catch (ClassNotFoundException e2) {
            isJava7x = false;
        }
        catch (NoSuchMethodException e3) {
            isJava7x = false;
        }
        IS_JAVA7 = isJava7x;
    }
}

