/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.controller.service;

import java.io.File;
import java.util.function.Consumer;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.internal.controller.service.LocalBuildCacheServiceHandle;
import org.gradle.caching.internal.packaging.UnrecoverableUnpackingException;
import org.gradle.caching.local.internal.LocalBuildCacheService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLocalBuildCacheServiceHandle
implements LocalBuildCacheServiceHandle {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultLocalBuildCacheServiceHandle.class);
    private final LocalBuildCacheService service;
    private final boolean pushEnabled;
    private final boolean logStackTraces;
    private volatile boolean disabled;

    public DefaultLocalBuildCacheServiceHandle(LocalBuildCacheService service, boolean pushEnabled, boolean logStackTraces) {
        this.service = service;
        this.pushEnabled = pushEnabled;
        this.logStackTraces = logStackTraces;
    }

    @Override
    public boolean canLoad() {
        return !this.disabled;
    }

    @Override
    public void load(BuildCacheKey key, Consumer<? super File> reader) {
        try {
            this.service.loadLocally(key, reader);
        }
        catch (UnrecoverableUnpackingException e2) {
            throw e2;
        }
        catch (Exception e3) {
            this.failure("load", "from", key, e3);
        }
    }

    @Override
    public boolean canStore() {
        return this.pushEnabled && !this.disabled;
    }

    @Override
    public void store(BuildCacheKey key, File file) {
        try {
            this.service.storeLocally(key, file);
        }
        catch (RuntimeException e2) {
            this.failure("store", "in", key, e2);
        }
    }

    private void failure(String verb, String preposition, BuildCacheKey key, Throwable e2) {
        this.disabled = true;
        String description = "Could not " + verb + " entry " + key.getDisplayName() + " " + preposition + " local build cache";
        if (LOGGER.isWarnEnabled()) {
            if (this.logStackTraces) {
                LOGGER.warn(description, e2);
            } else {
                LOGGER.warn(description + ": " + e2.getMessage());
            }
        }
    }

    @Override
    public void close() {
        if (this.disabled) {
            LOGGER.warn("The local build cache was disabled during the build due to errors.");
        }
        this.service.close();
    }
}

