/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.auth0.jwt.algorithms;

import com.gradle.maven.extension.internal.dep.com.auth0.jwt.algorithms.Algorithm;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.algorithms.CryptoHelper;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.exceptions.SignatureVerificationException;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.interfaces.DecodedJWT;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.interfaces.RSAKeyProvider;
import com.gradle.maven.extension.internal.dep.org.apache.commons.codec.binary.Base64;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

class RSAAlgorithm
extends Algorithm {
    private final RSAKeyProvider keyProvider;
    private final CryptoHelper crypto;

    RSAAlgorithm(CryptoHelper crypto, String id, String algorithm, RSAKeyProvider keyProvider) throws IllegalArgumentException {
        super(id, algorithm);
        if (keyProvider == null) {
            throw new IllegalArgumentException("The Key Provider cannot be null.");
        }
        this.keyProvider = keyProvider;
        this.crypto = crypto;
    }

    RSAAlgorithm(String id, String algorithm, RSAKeyProvider keyProvider) throws IllegalArgumentException {
        this(new CryptoHelper(), id, algorithm, keyProvider);
    }

    @Override
    public void verify(DecodedJWT jwt) throws SignatureVerificationException {
        byte[] contentBytes = String.format("%s.%s", jwt.getHeader(), jwt.getPayload()).getBytes(StandardCharsets.UTF_8);
        byte[] signatureBytes = Base64.decodeBase64(jwt.getSignature());
        try {
            RSAPublicKey publicKey = (RSAPublicKey)this.keyProvider.getPublicKeyById(jwt.getKeyId());
            if (publicKey == null) {
                throw new IllegalStateException("The given Public Key is null.");
            }
            boolean valid = this.crypto.verifySignatureFor(this.getDescription(), publicKey, contentBytes, signatureBytes);
            if (!valid) {
                throw new SignatureVerificationException(this);
            }
        }
        catch (IllegalStateException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e2) {
            throw new SignatureVerificationException(this, (Throwable)e2);
        }
    }

    static RSAKeyProvider providerForKeys(final RSAPublicKey publicKey, final RSAPrivateKey privateKey) {
        if (publicKey == null && privateKey == null) {
            throw new IllegalArgumentException("Both provided Keys cannot be null.");
        }
        return new RSAKeyProvider(){

            @Override
            public RSAPublicKey getPublicKeyById(String keyId) {
                return publicKey;
            }
        };
    }
}

