/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.auth0.jwt.impl;

import com.gradle.maven.extension.internal.dep.com.auth0.jwt.exceptions.JWTDecodeException;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.impl.PayloadImpl;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.interfaces.Payload;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.JsonProcessingException;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.core.type.TypeReference;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.JsonNode;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ObjectMapper;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;

class PayloadDeserializer
extends StdDeserializer<Payload> {
    PayloadDeserializer() {
        this((Class<?>)null);
    }

    private PayloadDeserializer(Class<?> vc) {
        super(vc);
    }

    @Override
    public Payload deserialize(JsonParser p2, DeserializationContext ctxt) throws IOException {
        Map tree = (Map)p2.getCodec().readValue(p2, new TypeReference<Map<String, JsonNode>>(){});
        if (tree == null) {
            throw new JWTDecodeException("Parsing the Payload's JSON resulted on a Null map");
        }
        String issuer = this.getString(tree, "iss");
        String subject = this.getString(tree, "sub");
        List<String> audience = this.getStringOrArray(tree, "aud");
        Date expiresAt = this.getDateFromSeconds(tree, "exp");
        Date notBefore = this.getDateFromSeconds(tree, "nbf");
        Date issuedAt = this.getDateFromSeconds(tree, "iat");
        String jwtId = this.getString(tree, "jti");
        return new PayloadImpl(issuer, subject, audience, expiresAt, notBefore, issuedAt, jwtId, tree);
    }

    List<String> getStringOrArray(Map<String, JsonNode> tree, String claimName) throws JWTDecodeException {
        JsonNode node = tree.get(claimName);
        if (node == null || node.isNull() || !node.isArray() && !node.isTextual()) {
            return null;
        }
        if (node.isTextual() && !node.asText().isEmpty()) {
            return Collections.singletonList(node.asText());
        }
        ObjectMapper mapper = new ObjectMapper();
        ArrayList<String> list = new ArrayList<String>(node.size());
        for (int i2 = 0; i2 < node.size(); ++i2) {
            try {
                list.add(mapper.treeToValue(node.get(i2), String.class));
                continue;
            }
            catch (JsonProcessingException e2) {
                throw new JWTDecodeException("Couldn't map the Claim's array contents to String", e2);
            }
        }
        return list;
    }

    Date getDateFromSeconds(Map<String, JsonNode> tree, String claimName) {
        JsonNode node = tree.get(claimName);
        if (node == null || node.isNull()) {
            return null;
        }
        if (!node.canConvertToLong()) {
            throw new JWTDecodeException(String.format("The claim '%s' contained a non-numeric date value.", claimName));
        }
        long ms = node.asLong() * 1000L;
        return new Date(ms);
    }

    String getString(Map<String, JsonNode> tree, String claimName) {
        JsonNode node = tree.get(claimName);
        if (node == null || node.isNull()) {
            return null;
        }
        return node.asText(null);
    }
}

