/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.pattern;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.internal.file.pattern.PatternStep;

public class RegExpPatternStep
implements PatternStep {
    private final Pattern pattern;

    public RegExpPatternStep(String pattern, boolean caseSensitive) {
        this.pattern = Pattern.compile(RegExpPatternStep.getRegExPattern(pattern), caseSensitive ? 0 : 2);
    }

    public String toString() {
        return "{regexp: " + this.pattern + "}";
    }

    protected static String getRegExPattern(String pattern) {
        StringBuilder result = new StringBuilder();
        for (int i2 = 0; i2 < pattern.length(); ++i2) {
            char next = pattern.charAt(i2);
            if (next == '*') {
                result.append(".*");
                continue;
            }
            if (next == '?') {
                result.append(".");
                continue;
            }
            if ("\\[]^-&.{}()$+|<=!".indexOf(next) >= 0) {
                result.append('\\');
                result.append(next);
                continue;
            }
            result.append(next);
        }
        return result.toString();
    }

    @Override
    public boolean matches(String testString) {
        Matcher matcher = this.pattern.matcher(testString);
        return matcher.matches();
    }
}

