/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.http.internal;

import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableSet;
import com.gradle.maven.extension.internal.dep.org.apache.http.HttpMessage;
import com.gradle.maven.extension.internal.dep.org.apache.http.StatusLine;
import com.gradle.maven.extension.internal.dep.org.apache.http.client.ClientProtocolException;
import com.gradle.maven.extension.internal.dep.org.apache.http.client.NonRepeatableRequestException;
import com.gradle.maven.extension.internal.dep.org.apache.http.client.methods.HttpGet;
import com.gradle.maven.extension.internal.dep.org.apache.http.client.methods.HttpPut;
import com.gradle.maven.extension.internal.dep.org.apache.http.entity.AbstractHttpEntity;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import org.gradle.api.UncheckedIOException;
import org.gradle.caching.BuildCacheEntryReader;
import org.gradle.caching.BuildCacheEntryWriter;
import org.gradle.caching.BuildCacheException;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.BuildCacheService;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.resource.transport.http.HttpClientHelper;
import org.gradle.internal.resource.transport.http.HttpClientResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpBuildCacheService
implements BuildCacheService {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpBuildCacheService.class);
    private final URI root;
    private final HttpClientHelper httpClientHelper;
    private final ErrorHandler errorHandler;

    public HttpBuildCacheService(HttpClientHelper httpClientHelper, URI url, ErrorHandler errorHandler) {
        if (!url.getPath().endsWith("/")) {
            throw new IllegalArgumentException("HTTP cache root URI must end with '/'");
        }
        this.root = url;
        this.httpClientHelper = httpClientHelper;
        this.errorHandler = errorHandler;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean load(BuildCacheKey key, BuildCacheEntryReader reader) throws BuildCacheException {
        URI uri = this.root.resolve("./" + key.getHashCode());
        HttpGet httpGet = new HttpGet(uri);
        httpGet.addHeader("Accept", "application/vnd.gradle.build-cache-artifact.v1, */*");
        this.addDiagnosticHeaders(httpGet);
        try (HttpClientResponse response = this.httpClientHelper.performHttpRequest(httpGet);){
            int statusCode;
            StatusLine statusLine = response.getStatusLine();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Response for GET {}: {}", (Object)HttpBuildCacheService.safeUri(uri), (Object)statusLine);
            }
            if (this.isHttpSuccess(statusCode = statusLine.getStatusCode())) {
                reader.readFrom(response.getContent());
                boolean bl = true;
                return bl;
            }
            if (statusCode == 404) {
                boolean bl = false;
                return bl;
            }
            String defaultMessage = String.format("Loading entry from '%s' response status %d: %s", HttpBuildCacheService.safeUri(uri), statusCode, statusLine.getReasonPhrase());
            if (this.isRedirect(statusCode)) {
                boolean bl = this.handleRedirect(uri, response, statusCode, defaultMessage, "loading entry from");
                return bl;
            }
            boolean bl = this.errorHandler.handleError(response, defaultMessage);
            return bl;
        }
        catch (IOException e2) {
            throw HttpBuildCacheService.wrap(e2);
        }
    }

    private boolean handleRedirect(URI uri, HttpClientResponse response, int statusCode, String defaultMessage, String action) {
        String locationHeader = response.getHeader("Location");
        if (locationHeader == null) {
            return this.errorHandler.handleError(response, defaultMessage);
        }
        try {
            throw new BuildCacheException(String.format("Received unexpected redirect (HTTP %d) to %s when " + action + " '%s'. Ensure the configured URL for the remote build cache is correct.", statusCode, HttpBuildCacheService.safeUri(new URI(locationHeader)), HttpBuildCacheService.safeUri(uri)));
        }
        catch (URISyntaxException e2) {
            return this.errorHandler.handleError(response, defaultMessage);
        }
    }

    private boolean isRedirect(int statusCode) {
        return statusCode == 301 || statusCode == 302 || statusCode == 307;
    }

    private void addDiagnosticHeaders(HttpMessage request) {
    }

    @Override
    public void store(BuildCacheKey key, final BuildCacheEntryWriter output) throws BuildCacheException {
        URI uri = this.root.resolve(key.getHashCode());
        HttpPut httpPut = new HttpPut(uri);
        httpPut.addHeader("Content-Type", "application/vnd.gradle.build-cache-artifact.v1");
        this.addDiagnosticHeaders(httpPut);
        httpPut.setEntity(new AbstractHttpEntity(){

            @Override
            public boolean isRepeatable() {
                return false;
            }

            @Override
            public long getContentLength() {
                return output.getSize();
            }

            @Override
            public InputStream getContent() throws IOException, UnsupportedOperationException {
                throw new UnsupportedOperationException();
            }

            @Override
            public void writeTo(OutputStream outstream) throws IOException {
                output.writeTo(outstream);
            }

            @Override
            public boolean isStreaming() {
                return false;
            }
        });
        try (HttpClientResponse response = this.httpClientHelper.performHttpRequest(httpPut);){
            int statusCode;
            StatusLine statusLine = response.getStatusLine();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Response for PUT {}: {}", (Object)HttpBuildCacheService.safeUri(uri), (Object)statusLine);
            }
            if (!this.isHttpSuccess(statusCode = statusLine.getStatusCode())) {
                String defaultMessage = String.format("Storing entry at '%s' response status %d: %s", HttpBuildCacheService.safeUri(uri), statusCode, statusLine.getReasonPhrase());
                if (this.isRedirect(statusCode)) {
                    this.handleRedirect(uri, response, statusCode, defaultMessage, "storing entry at");
                } else {
                    this.errorHandler.handleError(response, defaultMessage);
                }
            }
        }
        catch (ClientProtocolException e2) {
            Throwable cause = e2.getCause();
            if (cause instanceof NonRepeatableRequestException) {
                throw HttpBuildCacheService.wrap(cause.getCause());
            }
            throw HttpBuildCacheService.wrap(cause);
        }
        catch (IOException e3) {
            throw HttpBuildCacheService.wrap(e3);
        }
    }

    private static BuildCacheException wrap(Throwable e2) {
        if (e2 instanceof Error) {
            throw (Error)e2;
        }
        throw new BuildCacheException(e2.getMessage(), e2);
    }

    private boolean isHttpSuccess(int statusCode) {
        return statusCode >= 200 && statusCode < 300;
    }

    @Override
    public void close() throws IOException {
        this.httpClientHelper.close();
    }

    private static URI safeUri(URI uri) {
        try {
            return new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e2) {
            throw UncheckedException.throwAsUncheckedException(e2);
        }
    }

    @FunctionalInterface
    public static interface ErrorHandler {
        public static final Set<Integer> FATAL_HTTP_ERROR_CODES = ImmutableSet.of(Integer.valueOf(305), Integer.valueOf(400), Integer.valueOf(401), Integer.valueOf(403), Integer.valueOf(407), Integer.valueOf(405), new Integer[]{406, 411, 415, 417, 426, 505, 511});
        public static final ErrorHandler DEFAULT = (response, defaultMessage) -> {
            int statusCode = response.getStatusLine().getStatusCode();
            if (FATAL_HTTP_ERROR_CODES.contains(statusCode)) {
                throw new UncheckedIOException(defaultMessage);
            }
            throw new BuildCacheException(defaultMessage);
        };

        public boolean handleError(HttpClientResponse var1, String var2);
    }
}

