/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.packaging.impl;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Strings;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableMap;
import com.gradle.maven.extension.internal.dep.org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import com.gradle.maven.extension.internal.dep.org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import com.gradle.maven.extension.internal.dep.org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.FileUtils;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.IOUtils;
import com.gradle.maven.extension.internal.dep.org.apache.commons.io.input.CloseShieldInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.caching.internal.CacheableEntity;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.caching.internal.origin.OriginReader;
import org.gradle.caching.internal.origin.OriginWriter;
import org.gradle.caching.internal.packaging.BuildCacheEntryPacker;
import org.gradle.caching.internal.packaging.UnrecoverableUnpackingException;
import org.gradle.caching.internal.packaging.impl.PackerDirectoryUtil;
import org.gradle.caching.internal.packaging.impl.PermissionUtils;
import org.gradle.caching.internal.packaging.impl.RelativePathParser;
import org.gradle.internal.file.FileType;
import org.gradle.internal.file.TreeType;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.StreamHasher;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.snapshot.DirectorySnapshot;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshotVisitor;
import org.gradle.internal.snapshot.MerkleDirectorySnapshotBuilder;
import org.gradle.internal.snapshot.RegularFileSnapshot;
import org.gradle.internal.snapshot.RelativePathStringTracker;

public class TarBuildCacheEntryPacker
implements BuildCacheEntryPacker {
    private static final Pattern TREE_PATH = Pattern.compile("(missing-)?tree-([^/]+)(?:/(.*))?");
    private static final ThreadLocal<byte[]> COPY_BUFFERS = new ThreadLocal<byte[]>(){

        protected byte[] a() {
            return new byte[65536];
        }

        @Override
        protected /* synthetic */ Object initialValue() {
            return this.a();
        }
    };
    private final StreamHasher streamHasher;
    private final StringInterner stringInterner;
    private final OperatingSystem operatingSystem = OperatingSystem.current();

    @Inject
    public TarBuildCacheEntryPacker(StreamHasher streamHasher, StringInterner stringInterner) {
        this.streamHasher = streamHasher;
        this.stringInterner = stringInterner;
    }

    @Override
    public BuildCacheEntryPacker.PackResult pack(CacheableEntity entity, Map<String, CurrentFileCollectionFingerprint> fingerprints, OutputStream output, OriginWriter writeOrigin) throws IOException {
        BufferedOutputStream bufferedOutput = output instanceof BufferedOutputStream ? (BufferedOutputStream)output : new BufferedOutputStream(output);
        try (TarArchiveOutputStream tarOutput = new TarArchiveOutputStream(bufferedOutput, "utf-8");){
            tarOutput.setLongFileMode(3);
            tarOutput.setBigNumberMode(2);
            tarOutput.setAddPaxHeadersForNonAsciiNames(true);
            this.packMetadata(writeOrigin, tarOutput);
            long entryCount = this.pack(entity, fingerprints, tarOutput);
            BuildCacheEntryPacker.PackResult packResult = new BuildCacheEntryPacker.PackResult(entryCount + 1L);
            return packResult;
        }
    }

    private void packMetadata(OriginWriter writeMetadata, TarArchiveOutputStream tarOutput) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        writeMetadata.execute(baos);
        TarBuildCacheEntryPacker.createTarEntry("METADATA", baos.size(), 33188, tarOutput);
        tarOutput.write(baos.toByteArray());
        tarOutput.closeArchiveEntry();
    }

    private long pack(CacheableEntity entity, Map<String, CurrentFileCollectionFingerprint> fingerprints, TarArchiveOutputStream tarOutput) {
        AtomicLong entries = new AtomicLong();
        entity.visitTrees((treeName, type, root) -> {
            if (root == null) {
                return;
            }
            CurrentFileCollectionFingerprint fingerprint = (CurrentFileCollectionFingerprint)fingerprints.get(treeName);
            try {
                entries.addAndGet(this.packTree(treeName, type, fingerprint, tarOutput));
            }
            catch (Exception ex) {
                throw new GradleException(String.format("Could not pack tree '%s': %s", treeName, ex.getMessage()), ex);
            }
        });
        return entries.get();
    }

    private long packTree(String name, TreeType type, CurrentFileCollectionFingerprint fingerprint, TarArchiveOutputStream tarOutput) {
        b packingVisitor = new b(tarOutput, name, type);
        fingerprint.accept(packingVisitor);
        return packingVisitor.a();
    }

    private static void createTarEntry(String path, long size, int mode, TarArchiveOutputStream tarOutput) throws IOException {
        TarArchiveEntry entry = new TarArchiveEntry(path, true);
        entry.setSize(size);
        entry.setMode(mode);
        tarOutput.putArchiveEntry(entry);
    }

    @Override
    public BuildCacheEntryPacker.UnpackResult unpack(CacheableEntity entity, InputStream input, OriginReader readOrigin) throws IOException {
        try (TarArchiveInputStream tarInput = new TarArchiveInputStream(input);){
            BuildCacheEntryPacker.UnpackResult unpackResult = this.unpack(entity, tarInput, readOrigin);
            return unpackResult;
        }
    }

    private BuildCacheEntryPacker.UnpackResult unpack(CacheableEntity entity, TarArchiveInputStream tarInput, OriginReader readOriginAction) throws IOException {
        OriginMetadata originMetadata;
        ImmutableMap.Builder treesBuilder = ImmutableMap.builder();
        entity.visitTrees((name, type, root) -> {
            if (root != null) {
                treesBuilder.put(name, new a(type, root));
            }
        });
        ImmutableMap<String, a> treesByName = treesBuilder.build();
        HashMap<String, FileSystemLocationSnapshot> snapshots = new HashMap<String, FileSystemLocationSnapshot>();
        AtomicLong entries = new AtomicLong();
        try {
            originMetadata = this.readEntries(tarInput, readOriginAction, treesByName, snapshots, entries);
        }
        catch (RuntimeException e2) {
            if (entries.get() != 0L) {
                throw new UnrecoverableUnpackingException("Unpacking failed after some entries had already been unpacked", e2);
            }
            throw e2;
        }
        if (originMetadata == null) {
            throw new IllegalStateException("Cached result format error, no origin metadata was found.");
        }
        return new BuildCacheEntryPacker.UnpackResult(originMetadata, entries.get(), snapshots);
    }

    private OriginMetadata readEntries(TarArchiveInputStream tarInput, OriginReader readOriginAction, ImmutableMap<String, a> treesByName, Map<String, FileSystemLocationSnapshot> snapshots, AtomicLong entries) throws IOException {
        TarArchiveEntry tarEntry = tarInput.getNextTarEntry();
        OriginMetadata originMetadata = null;
        while (tarEntry != null) {
            entries.addAndGet(1L);
            String path = tarEntry.getName();
            if (path.equals("METADATA")) {
                originMetadata = readOriginAction.execute(new CloseShieldInputStream(tarInput));
                tarEntry = tarInput.getNextTarEntry();
                continue;
            }
            Matcher matcher = TREE_PATH.matcher(path);
            if (!matcher.matches()) {
                throw new IllegalStateException("Cached entry format error, invalid contents: " + path);
            }
            String treeName = TarBuildCacheEntryPacker.unescape(matcher.group(2));
            a tree = treesByName.get(treeName);
            if (tree == null) {
                throw new IllegalStateException(String.format("No tree '%s' registered", treeName));
            }
            boolean missing = matcher.group(1) != null;
            String childPath = matcher.group(3);
            tarEntry = this.unpackTree(treeName, tree.a(), tree.b(), tarInput, tarEntry, childPath, missing, snapshots, entries);
        }
        return originMetadata;
    }

    private TarArchiveEntry unpackTree(String treeName, TreeType treeType, File treeRoot, TarArchiveInputStream input, TarArchiveEntry rootEntry, String childPath, boolean missing, Map<String, FileSystemLocationSnapshot> snapshots, AtomicLong entries) throws IOException {
        boolean isDirEntry = rootEntry.isDirectory();
        boolean root = Strings.isNullOrEmpty(childPath);
        if (!root) {
            throw new IllegalStateException("Root needs to be the first entry in a tree");
        }
        if (missing) {
            return input.getNextTarEntry();
        }
        PackerDirectoryUtil.ensureDirectoryForTree(treeType, treeRoot);
        if (treeType == TreeType.FILE) {
            if (isDirEntry) {
                throw new IllegalStateException("Should be a file: " + treeName);
            }
            RegularFileSnapshot fileSnapshot = this.unpackFile(input, rootEntry, treeRoot, treeRoot.getName());
            snapshots.put(treeName, fileSnapshot);
            return input.getNextTarEntry();
        }
        if (!isDirEntry) {
            throw new IllegalStateException("Should be a directory: " + treeName);
        }
        this.chmodUnpackedFile(rootEntry, treeRoot);
        return this.unpackDirectoryTree(input, rootEntry, snapshots, entries, treeRoot, treeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegularFileSnapshot unpackFile(TarArchiveInputStream input, TarArchiveEntry entry, File file, String fileName) throws IOException {
        HashCode hash;
        FileOutputStream output = new FileOutputStream(file);
        try {
            hash = this.streamHasher.hashCopy(input, output);
            this.chmodUnpackedFile(entry, file);
        }
        finally {
            try {
                ((OutputStream)output).close();
            }
            catch (IOException iOException) {}
        }
        String internedAbsolutePath = this.stringInterner.intern(file.getAbsolutePath());
        String internedFileName = this.stringInterner.intern(fileName);
        return new RegularFileSnapshot(internedAbsolutePath, internedFileName, hash, file.lastModified());
    }

    private TarArchiveEntry unpackDirectoryTree(TarArchiveInputStream input, TarArchiveEntry rootEntry, Map<String, FileSystemLocationSnapshot> snapshots, AtomicLong entries, File treeRoot, String treeName) throws IOException {
        TarArchiveEntry entry;
        RelativePathParser parser = new RelativePathParser();
        parser.rootPath(rootEntry.getName());
        MerkleDirectorySnapshotBuilder builder = MerkleDirectorySnapshotBuilder.noSortingRequired();
        String rootPath = this.stringInterner.intern(treeRoot.getAbsolutePath());
        String rootDirName = this.stringInterner.intern(treeRoot.getName());
        builder.preVisitDirectory(rootPath, rootDirName);
        while ((entry = input.getNextTarEntry()) != null) {
            boolean isDir = entry.isDirectory();
            int directoriesLeft = parser.nextPath(entry.getName(), isDir);
            for (int i2 = 0; i2 < directoriesLeft; ++i2) {
                builder.postVisitDirectory();
            }
            if (parser.getDepth() == 0) break;
            entries.addAndGet(1L);
            File file = new File(treeRoot, parser.getRelativePath());
            if (isDir) {
                FileUtils.forceMkdir(file);
                this.chmodUnpackedFile(entry, file);
                String internedAbsolutePath = this.stringInterner.intern(file.getAbsolutePath());
                String indernedDirName = this.stringInterner.intern(parser.getName());
                builder.preVisitDirectory(internedAbsolutePath, indernedDirName);
                continue;
            }
            RegularFileSnapshot fileSnapshot = this.unpackFile(input, entry, file, parser.getName());
            builder.visit(fileSnapshot);
        }
        for (int i3 = 0; i3 < parser.getDepth(); ++i3) {
            builder.postVisitDirectory();
        }
        snapshots.put(treeName, builder.getResult());
        return entry;
    }

    private void chmodUnpackedFile(TarArchiveEntry entry, File file) {
        if (!this.operatingSystem.isUnix()) {
            return;
        }
        try {
            Files.setPosixFilePermissions(file.toPath(), PermissionUtils.permissions(entry.getMode() & 0xFFF));
        }
        catch (IOException e2) {
            throw new UncheckedIOException(e2);
        }
    }

    private static String escape(String name) {
        try {
            return URLEncoder.encode(name, "utf-8");
        }
        catch (UnsupportedEncodingException ignored) {
            throw new AssertionError();
        }
    }

    private static String unescape(String name) {
        try {
            return URLDecoder.decode(name, "utf-8");
        }
        catch (UnsupportedEncodingException e2) {
            throw new AssertionError((Object)e2);
        }
    }

    private static class b
    implements FileSystemSnapshotVisitor {
        private final RelativePathStringTracker a;
        private final TarArchiveOutputStream b;
        private final String c;
        private final String d;
        private final TreeType e;
        private long f;

        public b(TarArchiveOutputStream tarOutput, String treeName, TreeType type) {
            this.b = tarOutput;
            this.c = "tree-" + TarBuildCacheEntryPacker.escape(treeName);
            this.d = this.c + "/";
            this.e = type;
            this.a = new RelativePathStringTracker();
        }

        @Override
        public boolean preVisitDirectory(DirectorySnapshot directorySnapshot) {
            boolean root = this.a.isRoot();
            this.a.enter(directorySnapshot);
            this.a(root, directorySnapshot);
            String targetPath = this.a(root);
            int mode = root ? 493 : PermissionUtils.permissions(new File(directorySnapshot.getAbsolutePath()));
            this.a(targetPath, mode, this.b);
            ++this.f;
            return true;
        }

        @Override
        public void visit(FileSystemLocationSnapshot fileSnapshot) {
            boolean root = this.a.isRoot();
            this.a.enter(fileSnapshot);
            String targetPath = this.a(root);
            if (fileSnapshot.getType() == FileType.Missing) {
                this.a(targetPath, this.b);
            } else {
                this.a(root, fileSnapshot);
                File file = new File(fileSnapshot.getAbsolutePath());
                int mode = PermissionUtils.permissions(file);
                this.a(file, targetPath, file.length(), mode, this.b);
            }
            this.a.leave();
            ++this.f;
        }

        @Override
        public void postVisitDirectory(DirectorySnapshot directorySnapshot) {
            this.a.leave();
        }

        public long a() {
            if (this.f == 0L) {
                this.a(this.c, this.b);
                ++this.f;
            }
            return this.f;
        }

        private void a(boolean root, FileSystemLocationSnapshot snapshot) {
            if (root) {
                switch (this.e) {
                    case DIRECTORY: {
                        if (snapshot.getType() == FileType.Directory) break;
                        throw new IllegalArgumentException(String.format("Expected '%s' to be a directory", snapshot.getAbsolutePath()));
                    }
                    case FILE: {
                        if (snapshot.getType() == FileType.RegularFile) break;
                        throw new IllegalArgumentException(String.format("Expected '%s' to be a file", snapshot.getAbsolutePath()));
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
        }

        private String a(boolean root) {
            if (root) {
                return this.c;
            }
            String relativePath = this.a.getRelativePathString();
            return this.d + relativePath;
        }

        private void a(String treePath, TarArchiveOutputStream tarOutput) {
            try {
                TarBuildCacheEntryPacker.createTarEntry("missing-" + treePath, 0L, 33188, tarOutput);
                tarOutput.closeArchiveEntry();
            }
            catch (IOException e2) {
                throw new UncheckedIOException(e2);
            }
        }

        private void a(String path, int mode, TarArchiveOutputStream tarOutput) {
            try {
                TarBuildCacheEntryPacker.createTarEntry(path + "/", 0L, 0x4000 | mode, tarOutput);
                tarOutput.closeArchiveEntry();
            }
            catch (IOException e2) {
                throw new UncheckedIOException(e2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void a(File inputFile, String path, long size, int mode, TarArchiveOutputStream tarOutput) {
            try {
                TarBuildCacheEntryPacker.createTarEntry(path, size, 0x8000 | mode, tarOutput);
                FileInputStream input = new FileInputStream(inputFile);
                try {
                    IOUtils.copyLarge(input, tarOutput, (byte[])COPY_BUFFERS.get());
                }
                finally {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
                tarOutput.closeArchiveEntry();
            }
            catch (IOException e2) {
                throw new UncheckedIOException(e2);
            }
        }
    }

    private static class a {
        private final TreeType a;
        private final File b;

        public a(TreeType type, File root) {
            this.a = type;
            this.b = root;
        }

        public TreeType a() {
            return this.a;
        }

        public File b() {
            return this.b;
        }
    }
}

