/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.hash;

import java.io.Serializable;

public class HashCode
implements Serializable,
Comparable<HashCode> {
    private static final char[] HEX_DIGITS = "0123456789abcdef".toCharArray();
    private final byte[] bytes;
    private long hashCode;

    private HashCode(byte[] bytes) {
        this.bytes = bytes;
    }

    static HashCode fromBytesNoCopy(byte[] bytes) {
        return new HashCode(bytes);
    }

    public static HashCode fromBytes(byte[] bytes) {
        if (bytes.length < 4 || bytes.length > 255) {
            throw new IllegalArgumentException(String.format("Invalid hash code length: %d bytes", bytes.length));
        }
        return HashCode.fromBytesNoCopy((byte[])bytes.clone());
    }

    public int length() {
        return this.bytes.length;
    }

    public byte[] toByteArray() {
        return (byte[])this.bytes.clone();
    }

    public int hashCode() {
        if (this.hashCode == 0L) {
            this.hashCode = (long)(this.bytes[0] & 0xFF | (this.bytes[1] & 0xFF) << 8 | (this.bytes[2] & 0xFF) << 16 | (this.bytes[3] & 0xFF) << 24) | 0x100000000L;
        }
        return (int)this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != HashCode.class) {
            return false;
        }
        byte[] b2 = ((HashCode)obj).bytes;
        byte[] a2 = this.bytes;
        int length = a2.length;
        if (b2.length != length) {
            return false;
        }
        for (int i2 = 0; i2 < length; ++i2) {
            if (a2[i2] == b2[i2]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(HashCode o2) {
        byte[] bytes2 = o2.bytes;
        int len1 = this.bytes.length;
        int len2 = bytes2.length;
        int length = Math.min(len1, len2);
        for (int idx = 0; idx < length; ++idx) {
            int result = this.bytes[idx] - bytes2[idx];
            if (result == 0) continue;
            return result;
        }
        return len1 - len2;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(2 * this.bytes.length);
        for (byte b2 : this.bytes) {
            sb.append(HEX_DIGITS[b2 >> 4 & 0xF]).append(HEX_DIGITS[b2 & 0xF]);
        }
        return sb.toString();
    }

    byte[] getBytes() {
        return this.bytes;
    }
}

