/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.hash;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Charsets;
import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.HashFunction;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.HashingOutputStream;
import org.gradle.internal.hash.PrimitiveHasher;
import org.gradle.internal.io.NullOutputStream;

public class Hashing {
    private static final HashFunction MD5 = c.a("MD5");
    private static final HashFunction SHA1 = c.a("SHA-1");
    private static final HashFunction DEFAULT = MD5;

    public static Hasher newHasher() {
        return DEFAULT.newHasher();
    }

    public static PrimitiveHasher newPrimitiveHasher() {
        return DEFAULT.newPrimitiveHasher();
    }

    public static HashCode signature(Class<?> type) {
        return Hashing.signature("CLASS:" + type.getName());
    }

    public static HashCode signature(String thing) {
        Hasher hasher = DEFAULT.newHasher();
        hasher.putString("SIGNATURE");
        hasher.putString(thing);
        return hasher.hash();
    }

    public static HashCode hashBytes(byte[] bytes) {
        return DEFAULT.hashBytes(bytes);
    }

    public static HashingOutputStream primitiveStreamHasher() {
        return Hashing.primitiveStreamHasher(NullOutputStream.INSTANCE);
    }

    public static HashingOutputStream primitiveStreamHasher(OutputStream output) {
        return new HashingOutputStream(DEFAULT, output);
    }

    private static class b
    implements Hasher {
        private final PrimitiveHasher a;
        private String b;

        public b(PrimitiveHasher unsafeHasher) {
            this.a = unsafeHasher;
        }

        @Override
        public void putHash(HashCode hashCode) {
            this.a.putInt(hashCode.length());
            this.a.putHash(hashCode);
        }

        @Override
        public void putInt(int value) {
            this.a.putInt(4);
            this.a.putInt(value);
        }

        @Override
        public void putBoolean(boolean value) {
            this.a.putInt(1);
            this.a.putBoolean(value);
        }

        @Override
        public void putString(CharSequence value) {
            this.a.putInt(value.length());
            this.a.putString(value);
        }

        @Override
        public void putNull() {
            this.putInt(0);
        }

        @Override
        public void markAsInvalid(String invalidReason) {
            this.b = invalidReason;
        }

        @Override
        public boolean isValid() {
            return this.b == null;
        }

        public String a() {
            return Preconditions.checkNotNull(this.b);
        }

        @Override
        public HashCode hash() {
            if (!this.isValid()) {
                throw new IllegalStateException("Hash is invalid: " + this.a());
            }
            return this.a.hash();
        }
    }

    private static class d
    implements PrimitiveHasher {
        private final MessageDigest a;
        private final ByteBuffer b = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);
        private boolean c;

        public d(MessageDigest digest) {
            this.a = digest;
        }

        private void a() {
            if (this.c) {
                throw new IllegalStateException("Cannot reuse hasher");
            }
        }

        @Override
        public void putByte(byte b2) {
            this.a();
            this.a.update(b2);
        }

        @Override
        public void putBytes(byte[] bytes) {
            this.a();
            this.a.update(bytes);
        }

        @Override
        public void putBytes(byte[] bytes, int off, int len) {
            this.a();
            this.a.update(bytes, off, len);
        }

        @Override
        public HashCode hash() {
            this.c = true;
            byte[] bytes = this.a.digest();
            return HashCode.fromBytesNoCopy(bytes);
        }

        private void a(int length) {
            this.a();
            this.a.update(this.b.array(), 0, length);
            ((Buffer)this.b).clear();
        }

        @Override
        public void putInt(int value) {
            this.b.putInt(value);
            this.a(4);
        }

        @Override
        public void putBoolean(boolean value) {
            this.a();
            this.putByte((byte)(value ? 1 : 0));
        }

        @Override
        public void putString(CharSequence value) {
            this.putBytes(value.toString().getBytes(Charsets.UTF_8));
        }

        @Override
        public void putHash(HashCode hashCode) {
            this.putBytes(hashCode.getBytes());
        }
    }

    private static class e
    extends c {
        private final String a;

        public e(String algorithm) {
            this.a = algorithm;
        }

        @Override
        protected MessageDigest a() {
            try {
                return MessageDigest.getInstance(this.a);
            }
            catch (NoSuchAlgorithmException e2) {
                throw new AssertionError((Object)e2);
            }
        }
    }

    private static class a
    extends c {
        private final MessageDigest a;

        public a(MessageDigest prototype) {
            this.a = prototype;
        }

        @Override
        protected MessageDigest a() {
            try {
                return (MessageDigest)this.a.clone();
            }
            catch (CloneNotSupportedException e2) {
                throw new AssertionError((Object)e2);
            }
        }
    }

    private static abstract class c
    implements HashFunction {
        private c() {
        }

        public static c a(String algorithm) {
            MessageDigest prototype;
            try {
                prototype = MessageDigest.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException e2) {
                throw new IllegalArgumentException("Cannot instantiate digest algorithm: " + algorithm);
            }
            try {
                prototype.clone();
                return new a(prototype);
            }
            catch (CloneNotSupportedException e3) {
                return new e(algorithm);
            }
        }

        @Override
        public PrimitiveHasher newPrimitiveHasher() {
            MessageDigest digest = this.a();
            return new d(digest);
        }

        @Override
        public Hasher newHasher() {
            return new b(this.newPrimitiveHasher());
        }

        @Override
        public HashCode hashBytes(byte[] bytes) {
            PrimitiveHasher hasher = this.newPrimitiveHasher();
            hasher.putBytes(bytes);
            return hasher.hash();
        }

        protected abstract MessageDigest a();
    }
}

