/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.os;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.gradle.internal.FileUtils;

public abstract class OperatingSystem {
    public static final f WINDOWS = new f();
    public static final c MAC_OS = new c();
    public static final d SOLARIS = new d();
    public static final b LINUX = new b();
    public static final a FREE_BSD = new a();
    public static final e UNIX = new e();
    private static OperatingSystem currentOs;
    private final String toStringValue;
    private final String osName = System.getProperty("os.name");
    private final String osVersion = System.getProperty("os.version");

    OperatingSystem() {
        this.toStringValue = this.getName() + " " + this.getVersion() + " " + System.getProperty("os.arch");
    }

    public static OperatingSystem current() {
        if (currentOs == null) {
            currentOs = OperatingSystem.forName(System.getProperty("os.name"));
        }
        return currentOs;
    }

    public static OperatingSystem forName(String os) {
        String osName = os.toLowerCase();
        if (osName.contains("windows")) {
            return WINDOWS;
        }
        if (osName.contains("mac os x") || osName.contains("darwin") || osName.contains("osx")) {
            return MAC_OS;
        }
        if (osName.contains("sunos") || osName.contains("solaris")) {
            return SOLARIS;
        }
        if (osName.contains("linux")) {
            return LINUX;
        }
        if (osName.contains("freebsd")) {
            return FREE_BSD;
        }
        return UNIX;
    }

    public String toString() {
        return this.toStringValue;
    }

    public String getName() {
        return this.osName;
    }

    public String getVersion() {
        return this.osVersion;
    }

    public boolean isWindows() {
        return false;
    }

    public boolean isUnix() {
        return false;
    }

    public abstract String getExecutableName(String var1);

    public File findInPath(String name) {
        String exeName = this.getExecutableName(name);
        if (exeName.contains(File.separator)) {
            File candidate = new File(exeName);
            if (candidate.isFile()) {
                return candidate;
            }
            return null;
        }
        for (File dir : this.getPath()) {
            File candidate = new File(dir, exeName);
            if (!candidate.isFile()) continue;
            return candidate;
        }
        return null;
    }

    public List<File> getPath() {
        String path = System.getenv(this.getPathVar());
        if (path == null) {
            return Collections.emptyList();
        }
        ArrayList<File> entries = new ArrayList<File>();
        for (String entry : path.split(Pattern.quote(File.pathSeparator))) {
            entries.add(new File(entry));
        }
        return entries;
    }

    public String getPathVar() {
        return "PATH";
    }

    static class d
    extends e {
        d() {
        }

        @Override
        protected String a() {
            return "sunos";
        }

        @Override
        protected String b() {
            String arch = System.getProperty("os.arch");
            if (arch.equals("i386") || arch.equals("x86")) {
                return "x86";
            }
            return super.b();
        }
    }

    static class a
    extends e {
        a() {
        }
    }

    static class b
    extends e {
        b() {
        }
    }

    static class c
    extends e {
        c() {
        }
    }

    static class e
    extends OperatingSystem {
        private final String a = this.c();

        e() {
        }

        @Override
        public String getExecutableName(String executablePath) {
            return executablePath;
        }

        @Override
        public boolean isUnix() {
            return true;
        }

        private String c() {
            String arch = this.b();
            String osPrefix = this.a();
            osPrefix = osPrefix + "-" + arch;
            return osPrefix;
        }

        protected String b() {
            String arch = System.getProperty("os.arch");
            if ("x86".equals(arch)) {
                arch = "i386";
            }
            if ("x86_64".equals(arch)) {
                arch = "amd64";
            }
            if ("powerpc".equals(arch)) {
                arch = "ppc";
            }
            return arch;
        }

        protected String a() {
            String osPrefix = this.getName().toLowerCase();
            int space = osPrefix.indexOf(" ");
            if (space != -1) {
                osPrefix = osPrefix.substring(0, space);
            }
            return osPrefix;
        }
    }

    static class f
    extends OperatingSystem {
        private final String a = this.a();

        f() {
        }

        @Override
        public boolean isWindows() {
            return true;
        }

        @Override
        public String getExecutableName(String executablePath) {
            return FileUtils.withExtension(executablePath, ".exe");
        }

        private String a() {
            String arch = System.getProperty("os.arch");
            if ("i386".equals(arch)) {
                arch = "x86";
            }
            return "win32-" + arch;
        }

        @Override
        public String getPathVar() {
            return "Path";
        }
    }
}

