/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.http;

import com.gradle.maven.extension.internal.dep.org.apache.commons.lang3.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.gradle.internal.resource.transport.http.HttpProxySettings;

public class DefaultHttpProxySettings
implements HttpProxySettings {
    private final HttpProxySettings.HttpProxy proxy;
    private final List<Pattern> nonProxyHosts;

    public DefaultHttpProxySettings(String proxyHost, int proxyPort, String proxyUser, String proxyPassword, String nonProxyHostsString) {
        this.proxy = StringUtils.isBlank(proxyHost) ? null : new HttpProxySettings.HttpProxy(proxyHost, proxyPort, proxyUser, proxyPassword);
        this.nonProxyHosts = DefaultHttpProxySettings.initNonProxyHosts(nonProxyHostsString);
    }

    private static List<Pattern> initNonProxyHosts(String nonProxyHostsString) {
        if (StringUtils.isBlank(nonProxyHostsString)) {
            return Collections.emptyList();
        }
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        for (String nonProxyHost : nonProxyHostsString.split("\\|")) {
            patterns.add(DefaultHttpProxySettings.createHostMatcher(nonProxyHost));
        }
        return patterns;
    }

    private static Pattern createHostMatcher(String nonProxyHost) {
        if (nonProxyHost.startsWith("*")) {
            return Pattern.compile(".*" + Pattern.quote(nonProxyHost.substring(1)));
        }
        if (nonProxyHost.endsWith("*")) {
            return Pattern.compile(Pattern.quote(nonProxyHost.substring(0, nonProxyHost.length() - 1)) + ".*");
        }
        return Pattern.compile(Pattern.quote(nonProxyHost));
    }

    @Override
    public HttpProxySettings.HttpProxy getProxy() {
        return this.proxy;
    }

    @Override
    public HttpProxySettings.HttpProxy getProxy(String host) {
        if (this.proxy == null || this.isNonProxyHost(host)) {
            return null;
        }
        return this.proxy;
    }

    private boolean isNonProxyHost(String host) {
        for (Pattern nonProxyHost : this.nonProxyHosts) {
            if (!nonProxyHost.matcher(host).matches()) continue;
            return true;
        }
        return false;
    }
}

