/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.http;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import com.gradle.maven.extension.internal.dep.com.google.common.base.Supplier;
import com.gradle.maven.extension.internal.dep.com.google.common.base.Suppliers;
import com.gradle.maven.extension.internal.dep.org.apache.http.HttpRequestInterceptor;
import com.gradle.maven.extension.internal.dep.org.apache.http.HttpResponseInterceptor;
import com.gradle.maven.extension.internal.dep.org.apache.http.conn.routing.HttpRoutePlanner;
import com.gradle.maven.extension.internal.dep.org.apache.http.conn.ssl.DefaultHostnameVerifier;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import java.net.ProxySelector;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.gradle.authentication.Authentication;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.resource.transport.http.HttpProxySettings;
import org.gradle.internal.resource.transport.http.HttpSettings;
import org.gradle.internal.resource.transport.http.HttpTimeoutSettings;
import org.gradle.internal.resource.transport.http.JavaSystemPropertiesHttpProxySettings;
import org.gradle.internal.resource.transport.http.JavaSystemPropertiesHttpTimeoutSettings;
import org.gradle.internal.resource.transport.http.JavaSystemPropertiesSecureHttpProxySettings;
import org.gradle.internal.resource.transport.http.SslContextFactory;

public class DefaultHttpSettings
implements HttpSettings {
    private final Collection<Authentication> authenticationSettings;
    private final SslContextFactory sslContextFactory;
    private final HostnameVerifier hostnameVerifier;
    private final boolean followRedirects;
    private HttpProxySettings proxySettings;
    private HttpProxySettings secureProxySettings;
    private HttpRoutePlanner routePlanner;
    private HttpTimeoutSettings timeoutSettings;
    private List<HttpRequestInterceptor> requestInterceptors;
    private List<HttpResponseInterceptor> responseInterceptors;
    private static final HostnameVerifier ALL_TRUSTING_HOSTNAME_VERIFIER = new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    };
    private static final SslContextFactory ALL_TRUSTING_SSL_CONTEXT_FACTORY = new SslContextFactory(){
        private final Supplier<SSLContext> a = Suppliers.memoize(new Supplier<SSLContext>(){

            public SSLContext a() {
                try {
                    SSLContext sslcontext = SSLContext.getInstance("TLS");
                    sslcontext.init(null, b, null);
                    return sslcontext;
                }
                catch (GeneralSecurityException e2) {
                    throw UncheckedException.throwAsUncheckedException(e2);
                }
            }

            @Override
            public /* synthetic */ Object get() {
                return this.a();
            }
        });
        private final TrustManager[] b = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};

        @Override
        public SSLContext createSslContext() {
            return this.a.get();
        }
    };

    public static Builder builder() {
        return new Builder();
    }

    private DefaultHttpSettings(Collection<Authentication> authenticationSettings, SslContextFactory sslContextFactory, HostnameVerifier hostnameVerifier, boolean followRedirects, HttpProxySettings proxySettings, HttpProxySettings secureProxySettings, HttpRoutePlanner routePlanner, List<HttpRequestInterceptor> requestInterceptors, List<HttpResponseInterceptor> responseInterceptors) {
        this.followRedirects = followRedirects;
        Preconditions.checkNotNull(authenticationSettings, "authenticationSettings");
        Preconditions.checkNotNull(sslContextFactory, "sslContextFactory");
        Preconditions.checkNotNull(hostnameVerifier, "hostnameVerifier");
        this.authenticationSettings = authenticationSettings;
        this.sslContextFactory = sslContextFactory;
        this.hostnameVerifier = hostnameVerifier;
        this.proxySettings = proxySettings;
        this.secureProxySettings = secureProxySettings;
        this.routePlanner = routePlanner;
        this.requestInterceptors = requestInterceptors;
        this.responseInterceptors = responseInterceptors;
    }

    @Override
    public HttpProxySettings getProxySettings() {
        if (this.proxySettings == null) {
            this.proxySettings = new JavaSystemPropertiesHttpProxySettings();
        }
        return this.proxySettings;
    }

    @Override
    public HttpProxySettings getSecureProxySettings() {
        if (this.secureProxySettings == null) {
            this.secureProxySettings = new JavaSystemPropertiesSecureHttpProxySettings();
        }
        return this.secureProxySettings;
    }

    @Override
    public HttpRoutePlanner getRoutePlanner() {
        if (this.routePlanner == null) {
            this.routePlanner = new SystemDefaultRoutePlanner(ProxySelector.getDefault());
        }
        return this.routePlanner;
    }

    @Override
    public HttpTimeoutSettings getTimeoutSettings() {
        if (this.timeoutSettings == null) {
            this.timeoutSettings = new JavaSystemPropertiesHttpTimeoutSettings();
        }
        return this.timeoutSettings;
    }

    @Override
    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    @Override
    public Collection<Authentication> getAuthenticationSettings() {
        return this.authenticationSettings;
    }

    @Override
    public SslContextFactory getSslContextFactory() {
        return this.sslContextFactory;
    }

    @Override
    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    @Override
    public List<HttpRequestInterceptor> getRequestInterceptors() {
        return this.requestInterceptors;
    }

    @Override
    public List<HttpResponseInterceptor> getResponseInterceptors() {
        return this.responseInterceptors;
    }

    public static class Builder {
        private Collection<Authentication> authenticationSettings;
        private SslContextFactory sslContextFactory;
        private HostnameVerifier hostnameVerifier;
        private boolean followRedirects = true;
        private HttpProxySettings proxySettings;
        private HttpProxySettings secureProxySettings;
        private HttpRoutePlanner routePlanner;
        private List<HttpRequestInterceptor> requestInterceptors = new ArrayList<HttpRequestInterceptor>();
        private List<HttpResponseInterceptor> responseInterceptors = new ArrayList<HttpResponseInterceptor>();

        public Builder withAuthenticationSettings(Collection<Authentication> authenticationSettings) {
            this.authenticationSettings = authenticationSettings;
            return this;
        }

        public Builder withSslContextFactory(SslContextFactory sslContextFactory) {
            this.sslContextFactory = sslContextFactory;
            this.hostnameVerifier = new DefaultHostnameVerifier(null);
            return this;
        }

        public Builder allowUntrustedConnections() {
            this.sslContextFactory = ALL_TRUSTING_SSL_CONTEXT_FACTORY;
            this.hostnameVerifier = ALL_TRUSTING_HOSTNAME_VERIFIER;
            return this;
        }

        public Builder withProxySettings(HttpProxySettings proxySettings) {
            this.proxySettings = proxySettings;
            return this;
        }

        public Builder withSecureProxySettings(HttpProxySettings secureProxySettings) {
            this.secureProxySettings = secureProxySettings;
            return this;
        }

        public Builder withRoutePlanner(HttpRoutePlanner routePlanner) {
            this.routePlanner = routePlanner;
            return this;
        }

        public Builder addRequestInterceptor(HttpRequestInterceptor requestInterceptor) {
            this.requestInterceptors.add(requestInterceptor);
            return this;
        }

        public Builder addResponseInterceptor(HttpResponseInterceptor responseInterceptor) {
            this.responseInterceptors.add(responseInterceptor);
            return this;
        }

        public HttpSettings build() {
            return new DefaultHttpSettings(this.authenticationSettings, this.sslContextFactory, this.hostnameVerifier, this.followRedirects, this.proxySettings, this.secureProxySettings, this.routePlanner, this.requestInterceptors, this.responseInterceptors);
        }
    }
}

