/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.http;

import com.gradle.maven.extension.internal.dep.com.google.common.collect.Lists;
import com.gradle.maven.extension.internal.dep.org.apache.http.HttpException;
import com.gradle.maven.extension.internal.dep.org.apache.http.HttpHost;
import com.gradle.maven.extension.internal.dep.org.apache.http.HttpRequest;
import com.gradle.maven.extension.internal.dep.org.apache.http.HttpRequestInterceptor;
import com.gradle.maven.extension.internal.dep.org.apache.http.auth.AuthScheme;
import com.gradle.maven.extension.internal.dep.org.apache.http.auth.AuthScope;
import com.gradle.maven.extension.internal.dep.org.apache.http.auth.AuthState;
import com.gradle.maven.extension.internal.dep.org.apache.http.auth.UsernamePasswordCredentials;
import com.gradle.maven.extension.internal.dep.org.apache.http.client.CredentialsProvider;
import com.gradle.maven.extension.internal.dep.org.apache.http.client.config.RequestConfig;
import com.gradle.maven.extension.internal.dep.org.apache.http.config.RegistryBuilder;
import com.gradle.maven.extension.internal.dep.org.apache.http.config.SocketConfig;
import com.gradle.maven.extension.internal.dep.org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import com.gradle.maven.extension.internal.dep.org.apache.http.conn.util.PublicSuffixMatcher;
import com.gradle.maven.extension.internal.dep.org.apache.http.conn.util.PublicSuffixMatcherLoader;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.auth.BasicScheme;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.auth.BasicSchemeFactory;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.auth.DigestSchemeFactory;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.auth.KerberosSchemeFactory;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.auth.SPNegoSchemeFactory;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.client.HttpClientBuilder;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.client.SystemDefaultCredentialsProvider;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.cookie.DefaultCookieSpecProvider;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.cookie.IgnoreSpecProvider;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.cookie.NetscapeDraftSpecProvider;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.cookie.RFC6265CookieSpecProvider;
import com.gradle.maven.extension.internal.dep.org.apache.http.protocol.HttpContext;
import java.util.Collection;
import java.util.Collections;
import javax.net.ssl.HostnameVerifier;
import org.gradle.api.JavaVersion;
import org.gradle.api.credentials.Credentials;
import org.gradle.api.credentials.HttpHeaderCredentials;
import org.gradle.api.credentials.PasswordCredentials;
import org.gradle.authentication.Authentication;
import org.gradle.authentication.http.BasicAuthentication;
import org.gradle.authentication.http.DigestAuthentication;
import org.gradle.authentication.http.HttpHeaderAuthentication;
import org.gradle.internal.authentication.AllSchemesAuthentication;
import org.gradle.internal.authentication.AuthenticationInternal;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.resource.transport.http.AlwaysRedirectRedirectStrategy;
import org.gradle.internal.resource.transport.http.HttpClientHttpHeaderCredentials;
import org.gradle.internal.resource.transport.http.HttpHeaderAuthScheme;
import org.gradle.internal.resource.transport.http.HttpHeaderSchemeFactory;
import org.gradle.internal.resource.transport.http.HttpProxySettings;
import org.gradle.internal.resource.transport.http.HttpSettings;
import org.gradle.internal.resource.transport.http.HttpTimeoutSettings;
import org.gradle.internal.resource.transport.http.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientConfigurer {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClientConfigurer.class);
    private static final String[] SSL_PROTOCOLS;
    private final HttpSettings httpSettings;

    public HttpClientConfigurer(HttpSettings httpSettings) {
        this.httpSettings = httpSettings;
    }

    public void configure(HttpClientBuilder builder) {
        SystemDefaultCredentialsProvider credentialsProvider = new SystemDefaultCredentialsProvider();
        this.configureSslSocketConnectionFactory(builder, this.httpSettings.getSslContextFactory(), this.httpSettings.getHostnameVerifier());
        this.configureAuthSchemeRegistry(builder);
        this.configureCredentials(builder, credentialsProvider, this.httpSettings.getAuthenticationSettings());
        this.configureProxy(builder, credentialsProvider, this.httpSettings);
        this.configureUserAgent(builder);
        this.configureCookieSpecRegistry(builder);
        this.configureRequestConfig(builder);
        this.configureSocketConfig(builder);
        this.configureRedirectStrategy(builder);
        this.httpSettings.getRequestInterceptors().forEach(builder::addInterceptorFirst);
        this.httpSettings.getResponseInterceptors().forEach(builder::addInterceptorFirst);
        builder.setDefaultCredentialsProvider(credentialsProvider);
        builder.setMaxConnTotal(20);
        builder.setMaxConnPerRoute(20);
    }

    private void configureSslSocketConnectionFactory(HttpClientBuilder builder, SslContextFactory sslContextFactory, HostnameVerifier hostnameVerifier) {
        builder.setSSLSocketFactory(new SSLConnectionSocketFactory(sslContextFactory.createSslContext(), SSL_PROTOCOLS, null, hostnameVerifier));
    }

    private void configureAuthSchemeRegistry(HttpClientBuilder builder) {
        builder.setDefaultAuthSchemeRegistry(RegistryBuilder.create().register("Basic", new BasicSchemeFactory()).register("Digest", (BasicSchemeFactory)((Object)new DigestSchemeFactory())).register("Negotiate", (BasicSchemeFactory)((Object)new SPNegoSchemeFactory())).register("Kerberos", (BasicSchemeFactory)((Object)new KerberosSchemeFactory())).register("header", (BasicSchemeFactory)((Object)new HttpHeaderSchemeFactory())).build());
    }

    private void configureCredentials(HttpClientBuilder builder, CredentialsProvider credentialsProvider, Collection<Authentication> authentications) {
        if (authentications.size() > 0) {
            this.useCredentials(credentialsProvider, AuthScope.ANY_HOST, -1, authentications);
            builder.addInterceptorFirst(new a(this.getAuthScheme(authentications), this.isPreemptiveEnabled(authentications)));
        }
    }

    private AuthScheme getAuthScheme(Collection<Authentication> authentications) {
        if (authentications.size() == 1 && authentications.iterator().next() instanceof HttpHeaderAuthentication) {
            return new HttpHeaderAuthScheme();
        }
        return new BasicScheme();
    }

    private void configureProxy(HttpClientBuilder builder, CredentialsProvider credentialsProvider, HttpSettings httpSettings) {
        HttpProxySettings.HttpProxy httpProxy = httpSettings.getProxySettings().getProxy();
        HttpProxySettings.HttpProxy httpsProxy = httpSettings.getSecureProxySettings().getProxy();
        for (HttpProxySettings.HttpProxy proxy : Lists.newArrayList(httpProxy, httpsProxy)) {
            if (proxy == null || proxy.credentials == null) continue;
            this.useCredentials(credentialsProvider, proxy.host, proxy.port, Collections.singleton(new AllSchemesAuthentication(proxy.credentials)));
        }
        builder.setRoutePlanner(httpSettings.getRoutePlanner());
    }

    private void useCredentials(CredentialsProvider credentialsProvider, String host, int port, Collection<? extends Authentication> authentications) {
        for (Authentication authentication : authentications) {
            com.gradle.maven.extension.internal.dep.org.apache.http.auth.Credentials httpCredentials;
            String scheme = this.getAuthScheme(authentication);
            Credentials credentials = ((AuthenticationInternal)authentication).getCredentials();
            if (credentials instanceof HttpHeaderCredentials) {
                HttpHeaderCredentials httpHeaderCredentials = (HttpHeaderCredentials)credentials;
                httpCredentials = new HttpClientHttpHeaderCredentials(httpHeaderCredentials.getName(), httpHeaderCredentials.getValue());
                credentialsProvider.setCredentials(new AuthScope(host, port, AuthScope.ANY_REALM, scheme), httpCredentials);
                LOGGER.debug("Using {} for authenticating against '{}:{}' using {}", new Object[]{httpHeaderCredentials, host, port, scheme});
                continue;
            }
            if (credentials instanceof PasswordCredentials) {
                PasswordCredentials passwordCredentials = (PasswordCredentials)credentials;
                httpCredentials = new UsernamePasswordCredentials(passwordCredentials.getUsername(), passwordCredentials.getPassword());
                credentialsProvider.setCredentials(new AuthScope(host, port, AuthScope.ANY_REALM, scheme), httpCredentials);
                LOGGER.debug("Using {} for authenticating against '{}:{}' using {}", new Object[]{passwordCredentials, host, port, scheme});
                continue;
            }
            throw new IllegalArgumentException(String.format("Credentials must be an instance of: %s or %s", PasswordCredentials.class.getCanonicalName(), HttpHeaderCredentials.class.getCanonicalName()));
        }
    }

    private boolean isPreemptiveEnabled(Collection<Authentication> authentications) {
        return authentications.stream().anyMatch(element -> element instanceof BasicAuthentication || element instanceof HttpHeaderAuthentication);
    }

    public void configureUserAgent(HttpClientBuilder builder) {
    }

    private void configureCookieSpecRegistry(HttpClientBuilder builder) {
        PublicSuffixMatcher publicSuffixMatcher = PublicSuffixMatcherLoader.getDefault();
        builder.setPublicSuffixMatcher(publicSuffixMatcher);
        DefaultCookieSpecProvider defaultProvider = new DefaultCookieSpecProvider(DefaultCookieSpecProvider.CompatibilityLevel.DEFAULT, publicSuffixMatcher, new String[]{"EEE, dd-MMM-yy HH:mm:ss z", "EEE, dd-MMM-yy HH:mm:ss zzz", "EEE MMM d HH:mm:ss yyyy", "EEE, dd MMM yyyy HH:mm:ss zzz"}, false);
        RFC6265CookieSpecProvider laxStandardProvider = new RFC6265CookieSpecProvider(RFC6265CookieSpecProvider.CompatibilityLevel.RELAXED, publicSuffixMatcher);
        RFC6265CookieSpecProvider strictStandardProvider = new RFC6265CookieSpecProvider(RFC6265CookieSpecProvider.CompatibilityLevel.STRICT, publicSuffixMatcher);
        builder.setDefaultCookieSpecRegistry(RegistryBuilder.create().register("default", defaultProvider).register("best-match", defaultProvider).register("compatibility", defaultProvider).register("standard", (DefaultCookieSpecProvider)((Object)laxStandardProvider)).register("standard-strict", (DefaultCookieSpecProvider)((Object)strictStandardProvider)).register("netscape", (DefaultCookieSpecProvider)((Object)new NetscapeDraftSpecProvider())).register("ignoreCookies", (DefaultCookieSpecProvider)((Object)new IgnoreSpecProvider())).build());
    }

    private void configureRequestConfig(HttpClientBuilder builder) {
        HttpTimeoutSettings timeoutSettings = this.httpSettings.getTimeoutSettings();
        RequestConfig config = RequestConfig.custom().setConnectTimeout(timeoutSettings.getConnectionTimeoutMs()).setSocketTimeout(timeoutSettings.getSocketTimeoutMs()).build();
        builder.setDefaultRequestConfig(config);
    }

    private void configureSocketConfig(HttpClientBuilder builder) {
        HttpTimeoutSettings timeoutSettings = this.httpSettings.getTimeoutSettings();
        builder.setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(timeoutSettings.getSocketTimeoutMs()).setSoKeepAlive(true).build());
    }

    private void configureRedirectStrategy(HttpClientBuilder builder) {
        if (this.httpSettings.isFollowRedirects()) {
            builder.setRedirectStrategy(new AlwaysRedirectRedirectStrategy());
        } else {
            builder.disableRedirectHandling();
        }
    }

    private String getAuthScheme(Authentication authentication) {
        if (authentication instanceof BasicAuthentication) {
            return "Basic";
        }
        if (authentication instanceof DigestAuthentication) {
            return "Digest";
        }
        if (authentication instanceof HttpHeaderAuthentication) {
            return "header";
        }
        if (authentication instanceof AllSchemesAuthentication) {
            return AuthScope.ANY_SCHEME;
        }
        throw new IllegalArgumentException(String.format("Authentication scheme of '%s' is not supported.", authentication.getClass().getSimpleName()));
    }

    static {
        String httpsProtocols = System.getProperty("https.protocols");
        SSL_PROTOCOLS = httpsProtocols != null ? httpsProtocols.split(",") : (JavaVersion.current().isJava7() || JavaVersion.current().isJava8() && Jvm.current().isIbmJvm() ? new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"} : null);
    }

    static class a
    implements HttpRequestInterceptor {
        private final AuthScheme a;
        private final boolean b;

        a(AuthScheme authScheme, boolean alwaysSendAuth) {
            this.a = authScheme;
            this.b = alwaysSendAuth;
        }

        @Override
        public void process(HttpRequest request, HttpContext context) throws HttpException {
            AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
            if (authState.getAuthScheme() != null || authState.hasAuthOptions()) {
                return;
            }
            String requestMethod = request.getRequestLine().getMethod();
            if (this.b || requestMethod.equals("PUT") || requestMethod.equals("POST")) {
                HttpHost targetHost;
                CredentialsProvider credentialsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
                com.gradle.maven.extension.internal.dep.org.apache.http.auth.Credentials credentials = credentialsProvider.getCredentials(new AuthScope((targetHost = (HttpHost)context.getAttribute("http.target_host")).getHostName(), targetHost.getPort()));
                if (credentials == null) {
                    throw new HttpException("No credentials for preemptive authentication");
                }
                authState.update(this.a, credentials);
            }
        }
    }
}

