/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.http;

import com.gradle.maven.extension.internal.dep.com.google.common.collect.Iterables;
import com.gradle.maven.extension.internal.dep.org.apache.http.client.methods.CloseableHttpResponse;
import com.gradle.maven.extension.internal.dep.org.apache.http.client.methods.HttpRequestBase;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.client.CloseableHttpClient;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.client.HttpClientBuilder;
import com.gradle.maven.extension.internal.dep.org.apache.http.protocol.BasicHttpContext;
import com.gradle.maven.extension.internal.dep.org.apache.http.protocol.HttpContext;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.gradle.internal.resource.transport.http.HttpClientConfigurer;
import org.gradle.internal.resource.transport.http.HttpClientResponse;
import org.gradle.internal.resource.transport.http.HttpSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientHelper
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClientHelper.class);
    private CloseableHttpClient client;
    private final HttpSettings settings;
    private final ConcurrentLinkedQueue<HttpContext> sharedContext;

    public HttpClientHelper(HttpSettings settings) {
        this.settings = settings;
        this.sharedContext = !settings.getAuthenticationSettings().isEmpty() ? new ConcurrentLinkedQueue() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpClientResponse performHttpRequest(HttpRequestBase request) throws IOException {
        if (this.sharedContext == null) {
            return this.performHttpRequest(request, new BasicHttpContext());
        }
        HttpContext httpContext = this.nextAvailableSharedContext();
        try {
            HttpClientResponse httpClientResponse = this.performHttpRequest(request, httpContext);
            return httpClientResponse;
        }
        finally {
            this.sharedContext.add(httpContext);
        }
    }

    private HttpContext nextAvailableSharedContext() {
        HttpContext context = this.sharedContext.poll();
        if (context == null) {
            return new BasicHttpContext();
        }
        return context;
    }

    private HttpClientResponse performHttpRequest(HttpRequestBase request, HttpContext httpContext) throws IOException {
        httpContext.removeAttribute("http.protocol.redirect-locations");
        LOGGER.debug("Performing HTTP {}: {}", (Object)request.getMethod(), (Object)request.getURI());
        try {
            CloseableHttpResponse response = this.getClient().execute(request, httpContext);
            return this.toHttpClientResponse(request, httpContext, response);
        }
        catch (IOException e2) {
            URI lastRedirectLocation = this.getLastRedirectLocation(httpContext);
            throw lastRedirectLocation == null ? e2 : new a(lastRedirectLocation, e2);
        }
    }

    private HttpClientResponse toHttpClientResponse(HttpRequestBase request, HttpContext httpContext, CloseableHttpResponse response) {
        URI lastRedirectLocation = this.getLastRedirectLocation(httpContext);
        URI effectiveUri = lastRedirectLocation == null ? request.getURI() : lastRedirectLocation;
        return new HttpClientResponse(request.getMethod(), effectiveUri, response);
    }

    private URI getLastRedirectLocation(HttpContext httpContext) {
        List redirectLocations = (List)httpContext.getAttribute("http.protocol.redirect-locations");
        return redirectLocations == null || redirectLocations.isEmpty() ? null : (URI)Iterables.getLast(redirectLocations);
    }

    private synchronized CloseableHttpClient getClient() {
        if (this.client == null) {
            HttpClientBuilder builder = HttpClientBuilder.create();
            new HttpClientConfigurer(this.settings).configure(builder);
            this.client = builder.build();
        }
        return this.client;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.client != null) {
            this.client.close();
            if (this.sharedContext != null) {
                this.sharedContext.clear();
            }
        }
    }

    private static class a
    extends IOException {
        private final URI a;

        private a(URI lastRedirectLocation, Throwable cause) {
            super(cause);
            this.a = lastRedirectLocation;
        }
    }
}

