/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.http;

import com.gradle.maven.extension.internal.dep.org.apache.commons.lang3.StringUtils;
import org.gradle.internal.resource.transport.http.DefaultHttpProxySettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JavaSystemPropertiesProxySettings
extends DefaultHttpProxySettings {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaSystemPropertiesProxySettings.class);
    private final String propertyPrefix;
    private final int defaultPort;

    public JavaSystemPropertiesProxySettings(String propertyPrefix, int defaultPort) {
        this(propertyPrefix, defaultPort, System.getProperty(propertyPrefix + ".proxyHost"), System.getProperty(propertyPrefix + ".proxyPort"), System.getProperty(propertyPrefix + ".proxyUser"), System.getProperty(propertyPrefix + ".proxyPassword"), System.getProperty(propertyPrefix + ".nonProxyHosts"));
    }

    JavaSystemPropertiesProxySettings(String propertyPrefix, int defaultPort, String proxyHost, String proxyPortString, String proxyUser, String proxyPassword, String nonProxyHostsString) {
        super(proxyHost, JavaSystemPropertiesProxySettings.initProxyPort(propertyPrefix, defaultPort, proxyPortString), proxyUser, proxyPassword, nonProxyHostsString);
        this.propertyPrefix = propertyPrefix;
        this.defaultPort = defaultPort;
    }

    private static int initProxyPort(String propertyPrefix, int defaultPort, String proxyPortString) {
        if (StringUtils.isBlank(proxyPortString)) {
            return defaultPort;
        }
        try {
            return Integer.parseInt(proxyPortString);
        }
        catch (NumberFormatException e2) {
            String key = propertyPrefix + ".proxyPort";
            LOGGER.warn("Invalid value for java system property '{}': {}. Default port '{}' will be used.", new Object[]{key, System.getProperty(key), defaultPort});
            return defaultPort;
        }
    }
}

