/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.google.common.collect;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Optional;
import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import com.gradle.maven.extension.internal.dep.com.google.common.base.Predicate;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.AbstractIndexedListIterator;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableList;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.ImmutableSet;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Iterables;
import com.gradle.maven.extension.internal.dep.com.google.common.collect.Iterators;
import java.util.Arrays;
import java.util.Iterator;

public abstract class FluentIterable<E>
implements Iterable<E> {
    private final Optional<Iterable<E>> iterableDelegate;

    protected FluentIterable() {
        this.iterableDelegate = Optional.absent();
    }

    FluentIterable(Iterable<E> iterable) {
        Preconditions.checkNotNull(iterable);
        this.iterableDelegate = Optional.fromNullable(this != iterable ? iterable : null);
    }

    private Iterable<E> getDelegate() {
        return this.iterableDelegate.or(this);
    }

    public static <E> FluentIterable<E> from(final Iterable<E> iterable) {
        return iterable instanceof FluentIterable ? (FluentIterable<E>)iterable : new FluentIterable<E>(iterable){

            @Override
            public Iterator<E> iterator() {
                return iterable.iterator();
            }
        };
    }

    public static <T> FluentIterable<T> concat(Iterable<? extends T> ... inputs) {
        return FluentIterable.concatNoDefensiveCopy(Arrays.copyOf(inputs, inputs.length));
    }

    private static <T> FluentIterable<T> concatNoDefensiveCopy(final Iterable<? extends T> ... inputs) {
        for (Iterable<? extends T> input : inputs) {
            Preconditions.checkNotNull(input);
        }
        return new FluentIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Iterators.concat(new AbstractIndexedListIterator<Iterator<? extends T>>(inputs.length){

                    @Override
                    public Iterator<? extends T> get(int i2) {
                        return inputs[i2].iterator();
                    }
                });
            }
        };
    }

    public String toString() {
        return Iterables.toString(this.getDelegate());
    }

    public final FluentIterable<E> filter(Predicate<? super E> predicate) {
        return FluentIterable.from(Iterables.filter(this.getDelegate(), predicate));
    }

    public final ImmutableList<E> toList() {
        return ImmutableList.copyOf(this.getDelegate());
    }

    public final ImmutableSet<E> toSet() {
        return ImmutableSet.copyOf(this.getDelegate());
    }
}

