/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.auth0.jwt.impl;

import com.gradle.maven.extension.internal.dep.com.auth0.jwt.exceptions.JWTDecodeException;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.impl.HeaderDeserializer;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.impl.PayloadDeserializer;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.interfaces.Header;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.interfaces.Payload;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.annotation.JsonInclude;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.ObjectMapper;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.SerializationFeature;
import com.gradle.maven.extension.internal.dep.com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;

public class JWTParser {
    private ObjectMapper mapper;

    public JWTParser() {
        this(JWTParser.getDefaultObjectMapper());
    }

    JWTParser(ObjectMapper mapper) {
        this.addDeserializers(mapper);
        this.mapper = mapper;
    }

    public Payload parsePayload(String json) throws JWTDecodeException {
        return this.convertFromJSON(json, Payload.class);
    }

    public Header parseHeader(String json) throws JWTDecodeException {
        return this.convertFromJSON(json, Header.class);
    }

    private void addDeserializers(ObjectMapper mapper) {
        SimpleModule module = new SimpleModule();
        module.addDeserializer(Payload.class, new PayloadDeserializer());
        module.addDeserializer(Header.class, new HeaderDeserializer());
        mapper.registerModule(module);
    }

    static ObjectMapper getDefaultObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        return mapper;
    }

    <T> T convertFromJSON(String json, Class<T> tClazz) throws JWTDecodeException {
        if (json == null) {
            throw this.exceptionForInvalidJson(null);
        }
        try {
            return this.mapper.readValue(json, tClazz);
        }
        catch (IOException e2) {
            throw this.exceptionForInvalidJson(json);
        }
    }

    private JWTDecodeException exceptionForInvalidJson(String json) {
        return new JWTDecodeException(String.format("The string '%s' doesn't have a valid JSON format.", json));
    }
}

