/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.http.impl.io;

import com.gradle.maven.extension.internal.dep.org.apache.http.HttpException;
import com.gradle.maven.extension.internal.dep.org.apache.http.HttpResponse;
import com.gradle.maven.extension.internal.dep.org.apache.http.HttpResponseFactory;
import com.gradle.maven.extension.internal.dep.org.apache.http.NoHttpResponseException;
import com.gradle.maven.extension.internal.dep.org.apache.http.ParseException;
import com.gradle.maven.extension.internal.dep.org.apache.http.StatusLine;
import com.gradle.maven.extension.internal.dep.org.apache.http.config.MessageConstraints;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.DefaultHttpResponseFactory;
import com.gradle.maven.extension.internal.dep.org.apache.http.impl.io.AbstractMessageParser;
import com.gradle.maven.extension.internal.dep.org.apache.http.io.SessionInputBuffer;
import com.gradle.maven.extension.internal.dep.org.apache.http.message.LineParser;
import com.gradle.maven.extension.internal.dep.org.apache.http.message.ParserCursor;
import com.gradle.maven.extension.internal.dep.org.apache.http.util.CharArrayBuffer;
import java.io.IOException;

public class DefaultHttpResponseParser
extends AbstractMessageParser<HttpResponse> {
    private final HttpResponseFactory responseFactory;
    private final CharArrayBuffer lineBuf;

    public DefaultHttpResponseParser(SessionInputBuffer buffer, LineParser lineParser, HttpResponseFactory responseFactory, MessageConstraints constraints) {
        super(buffer, lineParser, constraints);
        this.responseFactory = responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE;
        this.lineBuf = new CharArrayBuffer(128);
    }

    @Override
    protected HttpResponse parseHead(SessionInputBuffer sessionBuffer) throws IOException, HttpException, ParseException {
        this.lineBuf.clear();
        int i2 = sessionBuffer.readLine(this.lineBuf);
        if (i2 == -1) {
            throw new NoHttpResponseException("The target server failed to respond");
        }
        ParserCursor cursor = new ParserCursor(0, this.lineBuf.length());
        StatusLine statusline = this.lineParser.parseStatusLine(this.lineBuf, cursor);
        return this.responseFactory.newHttpResponse(statusline, null);
    }
}

