/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.auth0.jwt;

import com.gradle.maven.extension.internal.dep.com.auth0.jwt.ClockImpl;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.JWT;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.algorithms.Algorithm;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.exceptions.AlgorithmMismatchException;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.exceptions.InvalidClaimException;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.exceptions.JWTVerificationException;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.exceptions.TokenExpiredException;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.interfaces.Claim;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.interfaces.Clock;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.interfaces.DecodedJWT;
import com.gradle.maven.extension.internal.dep.com.auth0.jwt.interfaces.Verification;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class JWTVerifier {
    private final Algorithm algorithm;
    final Map<String, Object> claims;
    private final Clock clock;

    JWTVerifier(Algorithm algorithm, Map<String, Object> claims, Clock clock) {
        this.algorithm = algorithm;
        this.claims = Collections.unmodifiableMap(claims);
        this.clock = clock;
    }

    static Verification init(Algorithm algorithm) throws IllegalArgumentException {
        return new BaseVerification(algorithm);
    }

    public DecodedJWT verify(String token) throws JWTVerificationException {
        DecodedJWT jwt = JWT.decode(token);
        this.verifyAlgorithm(jwt, this.algorithm);
        this.algorithm.verify(jwt);
        this.verifyClaims(jwt, this.claims);
        return jwt;
    }

    private void verifyAlgorithm(DecodedJWT jwt, Algorithm expectedAlgorithm) throws AlgorithmMismatchException {
        if (!expectedAlgorithm.getName().equals(jwt.getAlgorithm())) {
            throw new AlgorithmMismatchException("The provided Algorithm doesn't match the one defined in the JWT's Header.");
        }
    }

    private void verifyClaims(DecodedJWT jwt, Map<String, Object> claims) throws TokenExpiredException, InvalidClaimException {
        block18: for (Map.Entry<String, Object> entry : claims.entrySet()) {
            switch (entry.getKey()) {
                case "aud": {
                    this.assertValidAudienceClaim(jwt.getAudience(), (List)entry.getValue());
                    continue block18;
                }
                case "exp": {
                    this.assertValidDateClaim(jwt.getExpiresAt(), (Long)entry.getValue(), true);
                    continue block18;
                }
                case "iat": {
                    this.assertValidDateClaim(jwt.getIssuedAt(), (Long)entry.getValue(), false);
                    continue block18;
                }
                case "nbf": {
                    this.assertValidDateClaim(jwt.getNotBefore(), (Long)entry.getValue(), false);
                    continue block18;
                }
                case "iss": {
                    this.assertValidStringClaim(entry.getKey(), jwt.getIssuer(), (String)entry.getValue());
                    continue block18;
                }
                case "jti": {
                    this.assertValidStringClaim(entry.getKey(), jwt.getId(), (String)entry.getValue());
                    continue block18;
                }
                case "sub": {
                    this.assertValidStringClaim(entry.getKey(), jwt.getSubject(), (String)entry.getValue());
                    continue block18;
                }
            }
            this.assertValidClaim(jwt.getClaim(entry.getKey()), entry.getKey(), entry.getValue());
        }
    }

    private void assertValidClaim(Claim claim, String claimName, Object value) {
        boolean isValid = false;
        if (value instanceof String) {
            isValid = value.equals(claim.asString());
        } else if (value instanceof Integer) {
            isValid = value.equals(claim.asInt());
        } else if (value instanceof Long) {
            isValid = value.equals(claim.asLong());
        } else if (value instanceof Boolean) {
            isValid = value.equals(claim.asBoolean());
        } else if (value instanceof Double) {
            isValid = value.equals(claim.asDouble());
        } else if (value instanceof Date) {
            isValid = value.equals(claim.asDate());
        } else if (value instanceof Object[]) {
            List<Object> claimArr = Arrays.asList(claim.as(Object[].class));
            List<Object> valueArr = Arrays.asList((Object[])value);
            isValid = claimArr.containsAll(valueArr);
        }
        if (!isValid) {
            throw new InvalidClaimException(String.format("The Claim '%s' value doesn't match the required one.", claimName));
        }
    }

    private void assertValidStringClaim(String claimName, String value, String expectedValue) {
        if (!expectedValue.equals(value)) {
            throw new InvalidClaimException(String.format("The Claim '%s' value doesn't match the required one.", claimName));
        }
    }

    private void assertValidDateClaim(Date date, long leeway, boolean shouldBeFuture) {
        Date today = this.clock.getToday();
        today.setTime((long)Math.floor(today.getTime() / 1000L * 1000L));
        if (shouldBeFuture) {
            this.assertDateIsFuture(date, leeway, today);
        } else {
            this.assertDateIsPast(date, leeway, today);
        }
    }

    private void assertDateIsFuture(Date date, long leeway, Date today) {
        today.setTime(today.getTime() - leeway * 1000L);
        if (date != null && today.after(date)) {
            throw new TokenExpiredException(String.format("The Token has expired on %s.", date));
        }
    }

    private void assertDateIsPast(Date date, long leeway, Date today) {
        today.setTime(today.getTime() + leeway * 1000L);
        if (date != null && today.before(date)) {
            throw new InvalidClaimException(String.format("The Token can't be used before %s.", date));
        }
    }

    private void assertValidAudienceClaim(List<String> audience, List<String> value) {
        if (audience == null || !audience.containsAll(value)) {
            throw new InvalidClaimException("The Claim 'aud' value doesn't contain the required audience.");
        }
    }

    public static class BaseVerification
    implements Verification {
        private final Algorithm algorithm;
        private final Map<String, Object> claims;
        private long defaultLeeway;

        BaseVerification(Algorithm algorithm) throws IllegalArgumentException {
            if (algorithm == null) {
                throw new IllegalArgumentException("The Algorithm cannot be null.");
            }
            this.algorithm = algorithm;
            this.claims = new HashMap<String, Object>();
            this.defaultLeeway = 0L;
        }

        @Override
        public Verification withSubject(String subject) {
            this.requireClaim("sub", subject);
            return this;
        }

        @Override
        public Verification acceptLeeway(long leeway) throws IllegalArgumentException {
            this.assertPositive(leeway);
            this.defaultLeeway = leeway;
            return this;
        }

        @Override
        public JWTVerifier build() {
            return this.build(new ClockImpl());
        }

        public JWTVerifier build(Clock clock) {
            this.addLeewayToDateClaims();
            return new JWTVerifier(this.algorithm, this.claims, clock);
        }

        private void assertPositive(long leeway) {
            if (leeway < 0L) {
                throw new IllegalArgumentException("Leeway value can't be negative.");
            }
        }

        private void addLeewayToDateClaims() {
            if (!this.claims.containsKey("exp")) {
                this.claims.put("exp", this.defaultLeeway);
            }
            if (!this.claims.containsKey("nbf")) {
                this.claims.put("nbf", this.defaultLeeway);
            }
            if (!this.claims.containsKey("iat")) {
                this.claims.put("iat", this.defaultLeeway);
            }
        }

        private void requireClaim(String name, Object value) {
            if (value == null) {
                this.claims.remove(name);
                return;
            }
            this.claims.put(name, value);
        }
    }
}

