/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api;

import java.util.ArrayList;
import java.util.List;

public enum JavaVersion {
    VERSION_1_1,
    VERSION_1_2,
    VERSION_1_3,
    VERSION_1_4,
    VERSION_1_5,
    VERSION_1_6,
    VERSION_1_7,
    VERSION_1_8,
    VERSION_1_9,
    VERSION_1_10,
    VERSION_11,
    VERSION_12,
    VERSION_HIGHER;

    private static JavaVersion currentJavaVersion;
    private final String versionName = this.ordinal() >= 10 ? this.getMajorVersion() : "1." + this.getMajorVersion();

    public static JavaVersion toVersion(Object value) throws IllegalArgumentException {
        int firstNonVersionCharIndex;
        String[] versionStrings;
        if (value == null) {
            return null;
        }
        if (value instanceof JavaVersion) {
            return (JavaVersion)((Object)value);
        }
        String name = value.toString();
        List<Integer> versions = JavaVersion.convertToNumber(name, versionStrings = name.substring(0, firstNonVersionCharIndex = JavaVersion.findFirstNonVersionCharIndex(name)).split("\\."));
        if (JavaVersion.isLegacyVersion(versions)) {
            JavaVersion.assertTrue(name, versions.get(1) > 0);
            return JavaVersion.getVersionForMajor(versions.get(1));
        }
        return JavaVersion.getVersionForMajor(versions.get(0));
    }

    public static JavaVersion current() {
        if (currentJavaVersion == null) {
            currentJavaVersion = JavaVersion.toVersion(System.getProperty("java.version"));
        }
        return currentJavaVersion;
    }

    public String toString() {
        return this.versionName;
    }

    public String getMajorVersion() {
        return String.valueOf(this.ordinal() + 1);
    }

    private static JavaVersion getVersionForMajor(int major) {
        return major >= JavaVersion.values().length ? VERSION_HIGHER : JavaVersion.values()[major - 1];
    }

    private static void assertTrue(String value, boolean condition) {
        if (!condition) {
            throw new IllegalArgumentException("Could not determine java version from '" + value + "'.");
        }
    }

    private static boolean isLegacyVersion(List<Integer> versions) {
        return 1 == versions.get(0) && versions.size() > 1;
    }

    private static List<Integer> convertToNumber(String value, String[] versionStrs) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (String s2 : versionStrs) {
            JavaVersion.assertTrue(value, !JavaVersion.isNumberStartingWithZero(s2));
            try {
                result.add(Integer.parseInt(s2));
            }
            catch (NumberFormatException e2) {
                JavaVersion.assertTrue(value, false);
            }
        }
        JavaVersion.assertTrue(value, !result.isEmpty() && (Integer)result.get(0) > 0);
        return result;
    }

    private static boolean isNumberStartingWithZero(String number) {
        return number.length() > 1 && number.startsWith("0");
    }

    private static int findFirstNonVersionCharIndex(String s2) {
        JavaVersion.assertTrue(s2, s2.length() != 0);
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            if (JavaVersion.isDigitOrPeriod(s2.charAt(i2))) continue;
            JavaVersion.assertTrue(s2, i2 != 0);
            return i2;
        }
        return s2.length();
    }

    private static boolean isDigitOrPeriod(char c2) {
        return c2 >= '0' && c2 <= '9' || c2 == '.';
    }
}

