/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.gradle.maven.extension.internal.dep.com.google.common.io.ByteStreams;
import java.io.IOException;
import org.gradle.api.internal.changedetection.state.ResourceHasher;
import org.gradle.api.internal.changedetection.state.ZipEntry;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.hash.HashingOutputStream;
import org.gradle.internal.snapshot.RegularFileSnapshot;

public class RuntimeClasspathResourceHasher
implements ResourceHasher {
    @Override
    public HashCode hash(RegularFileSnapshot fileSnapshot) {
        return fileSnapshot.getHash();
    }

    @Override
    public HashCode hash(ZipEntry zipEntry) throws IOException {
        HashingOutputStream hasher = Hashing.primitiveStreamHasher();
        ByteStreams.copy(zipEntry.getInputStream(), hasher);
        return hasher.hash();
    }

    @Override
    public void appendConfigurationToHasher(Hasher hasher) {
        hasher.putString(this.getClass().getName());
    }
}

