/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.pattern;

import com.gradle.maven.extension.internal.dep.org.apache.commons.lang3.StringUtils;
import java.util.function.Predicate;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.pattern.AnythingMatcher;
import org.gradle.api.internal.file.pattern.EndOfPathMatcher;
import org.gradle.api.internal.file.pattern.FixedStepPathMatcher;
import org.gradle.api.internal.file.pattern.GreedyPathMatcher;
import org.gradle.api.internal.file.pattern.PathMatcher;
import org.gradle.api.internal.file.pattern.PatternStepFactory;

public class PatternMatcherFactory {
    private static final EndOfPathMatcher END_OF_PATH_MATCHER = new EndOfPathMatcher();

    public static Predicate<RelativePath> getPatternMatcher(boolean partialMatchDirs, boolean caseSensitive, String pattern) {
        PathMatcher pathMatcher = PatternMatcherFactory.compile(caseSensitive, pattern);
        return new a(partialMatchDirs, pathMatcher);
    }

    public static PathMatcher compile(boolean caseSensitive, String pattern) {
        if (pattern.length() == 0) {
            return END_OF_PATH_MATCHER;
        }
        if (pattern.endsWith("/") || pattern.endsWith("\\")) {
            pattern = pattern + "**";
        }
        String[] parts = StringUtils.split(pattern, "\\/");
        return PatternMatcherFactory.compile(parts, 0, caseSensitive);
    }

    private static PathMatcher compile(String[] parts, int startIndex, boolean caseSensitive) {
        int pos;
        if (startIndex >= parts.length) {
            return END_OF_PATH_MATCHER;
        }
        for (pos = startIndex; pos < parts.length && parts[pos].equals("**"); ++pos) {
        }
        if (pos > startIndex) {
            if (pos == parts.length) {
                return new AnythingMatcher();
            }
            return new GreedyPathMatcher(PatternMatcherFactory.compile(parts, pos, caseSensitive));
        }
        return new FixedStepPathMatcher(PatternStepFactory.getStep(parts[pos], caseSensitive), PatternMatcherFactory.compile(parts, pos + 1, caseSensitive));
    }

    static class a
    implements Predicate<RelativePath> {
        private final boolean a;
        private final PathMatcher b;

        a(boolean partialMatchDirs, PathMatcher pathMatcher) {
            this.a = partialMatchDirs;
            this.b = pathMatcher;
        }

        public boolean a(RelativePath element) {
            if (element.isFile() || !this.a) {
                return this.b.matches(element.getSegments(), 0);
            }
            return this.b.isPrefix(element.getSegments(), 0);
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.a((RelativePath)object);
        }
    }
}

