/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.controller;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Consumer;
import org.gradle.api.GradleException;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.internal.controller.BuildCacheController;
import org.gradle.caching.internal.controller.BuildCacheLoadCommand;
import org.gradle.caching.internal.controller.BuildCacheStoreCommand;
import org.gradle.caching.internal.controller.service.BuildCacheServiceHandle;
import org.gradle.caching.internal.controller.service.BuildCacheServiceHandleFactory;
import org.gradle.caching.internal.controller.service.BuildCacheServiceRole;
import org.gradle.caching.internal.controller.service.BuildCacheServicesConfiguration;
import org.gradle.caching.internal.controller.service.LoadTarget;
import org.gradle.caching.internal.controller.service.LocalBuildCacheServiceHandle;
import org.gradle.caching.internal.controller.service.NullLocalBuildCacheServiceHandle;
import org.gradle.caching.internal.controller.service.StoreTarget;
import org.gradle.caching.local.internal.BuildCacheTempFileStore;
import org.gradle.caching.local.internal.DefaultBuildCacheTempFileStore;
import org.gradle.internal.UncheckedException;

public class DefaultBuildCacheController
implements BuildCacheController {
    private final BuildCacheServiceHandle remote;
    private final LocalBuildCacheServiceHandle local;
    private final boolean emitDebugLogging;
    private final BuildCacheTempFileStore tmp;
    private boolean closed;

    public DefaultBuildCacheController(BuildCacheServicesConfiguration config, BuildCacheServiceHandleFactory handleFactory, File storageDirectory, boolean logStackTraces, boolean emitDebugLogging) {
        this.emitDebugLogging = emitDebugLogging;
        if (config.local == null) {
            this.local = NullLocalBuildCacheServiceHandle.INSTANCE;
            this.tmp = new DefaultBuildCacheTempFileStore(new File(storageDirectory, "build-cache-tmp"));
        } else {
            this.local = handleFactory.toHandle(config.local, config.localPush);
            this.tmp = config.local;
        }
        this.remote = handleFactory.toHandle(config.remote, config.remotePush, BuildCacheServiceRole.REMOTE, logStackTraces);
    }

    @Override
    public <T> T load(BuildCacheLoadCommand<T> command) {
        BuildCacheLoadCommand.Result result;
        b unpack = new b(command);
        if (this.local.canLoad()) {
            try {
                this.local.load(command.getKey(), unpack);
            }
            catch (Exception e2) {
                throw new GradleException("Build cache entry " + command.getKey().getHashCode() + " from local build cache is invalid", e2);
            }
            if (unpack.c != null) {
                return unpack.c.getMetadata();
            }
        }
        if (this.remote.canLoad()) {
            this.tmp.withTempFile(command.getKey(), file -> {
                LoadTarget loadTarget = new LoadTarget((File)file);
                if (this.remote.canLoad() && !loadTarget.isLoaded()) {
                    this.remote.load(command.getKey(), loadTarget);
                }
                if (loadTarget.isLoaded()) {
                    try {
                        unpack.a((File)file);
                    }
                    catch (Exception e2) {
                        String roleDisplayName = BuildCacheServiceRole.REMOTE.getDisplayName();
                        throw new GradleException("Build cache entry " + command.getKey().getHashCode() + " from " + roleDisplayName + " build cache is invalid", e2);
                    }
                    if (this.local.canStore()) {
                        this.local.store(command.getKey(), (File)file);
                    }
                }
            });
        }
        if ((result = unpack.c) == null) {
            return null;
        }
        return result.getMetadata();
    }

    @Override
    public void store(BuildCacheStoreCommand command) {
        boolean anyStore;
        boolean bl = anyStore = this.local.canStore() || this.remote.canStore();
        if (!anyStore) {
            return;
        }
        BuildCacheKey key = command.getKey();
        a pack = new a(command);
        this.tmp.withTempFile(command.getKey(), file -> {
            pack.a((File)file);
            if (this.remote.canStore()) {
                this.remote.store(key, new StoreTarget((File)file));
            }
            if (this.local.canStore()) {
                this.local.store(key, (File)file);
            }
        });
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            try {
                this.local.close();
            }
            finally {
                this.remote.close();
            }
        }
    }

    private class a
    implements Consumer<File> {
        private final BuildCacheStoreCommand b;

        private a(BuildCacheStoreCommand command) {
            this.b = command;
        }

        public void a(File file) {
            try {
                this.b.store(new FileOutputStream(file));
            }
            catch (IOException e2) {
                throw UncheckedException.throwAsUncheckedException(e2);
            }
        }

        @Override
        public /* synthetic */ void accept(Object object) {
            this.a((File)object);
        }
    }

    private class b<T>
    implements Consumer<File> {
        private final BuildCacheLoadCommand<T> b;
        private BuildCacheLoadCommand.Result<T> c;

        private b(BuildCacheLoadCommand<T> command) {
            this.b = command;
        }

        public void a(File file) {
            try (FileInputStream input = new FileInputStream(file);){
                this.c = this.b.load(input);
            }
            catch (IOException e2) {
                throw new UncheckedIOException(e2);
            }
        }

        @Override
        public /* synthetic */ void accept(Object object) {
            this.a((File)object);
        }
    }
}

