/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.controller.service;

import org.gradle.caching.BuildCacheEntryReader;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.BuildCacheService;
import org.gradle.caching.internal.controller.service.BuildCacheServiceHandle;
import org.gradle.caching.internal.controller.service.BuildCacheServiceRole;
import org.gradle.caching.internal.controller.service.LoadTarget;
import org.gradle.caching.internal.controller.service.StoreTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseBuildCacheServiceHandle
implements BuildCacheServiceHandle {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseBuildCacheServiceHandle.class);
    protected final BuildCacheService service;
    protected final BuildCacheServiceRole role;
    private final boolean pushEnabled;
    private final boolean logStackTraces;
    private boolean disabled;

    public BaseBuildCacheServiceHandle(BuildCacheService service, boolean push, BuildCacheServiceRole role, boolean logStackTraces) {
        this.role = role;
        this.service = service;
        this.pushEnabled = push;
        this.logStackTraces = logStackTraces;
    }

    public BuildCacheService getService() {
        return this.service;
    }

    @Override
    public boolean canLoad() {
        return !this.disabled;
    }

    @Override
    public final void load(BuildCacheKey key, LoadTarget loadTarget) {
        String description = "Load entry " + key.getDisplayName() + " from " + this.role.getDisplayName() + " build cache";
        LOGGER.debug(description);
        try {
            this.loadInner(description, key, loadTarget);
        }
        catch (Exception e2) {
            this.failure("load", "from", key, e2);
        }
    }

    protected void loadInner(String description, BuildCacheKey key, LoadTarget loadTarget) {
        this.service.load(key, loadTarget);
    }

    protected void loadInner(BuildCacheKey key, BuildCacheEntryReader entryReader) {
        this.service.load(key, entryReader);
    }

    @Override
    public boolean canStore() {
        return this.pushEnabled && !this.disabled;
    }

    @Override
    public final void store(BuildCacheKey key, StoreTarget storeTarget) {
        String description = "Store entry " + key.getDisplayName() + " in " + this.role.getDisplayName() + " build cache";
        LOGGER.debug(description);
        try {
            this.storeInner(description, key, storeTarget);
        }
        catch (Exception e2) {
            this.failure("store", "in", key, e2);
        }
    }

    protected void storeInner(String description, BuildCacheKey key, StoreTarget storeTarget) {
        this.service.store(key, storeTarget);
    }

    private void failure(String verb, String preposition, BuildCacheKey key, Throwable e2) {
        this.disabled = true;
        String description = "Could not " + verb + " entry " + key.getDisplayName() + " " + preposition + " " + this.role.getDisplayName() + " build cache";
        if (LOGGER.isWarnEnabled()) {
            if (this.logStackTraces) {
                LOGGER.warn(description, e2);
            } else {
                LOGGER.warn(description + ": " + e2.getMessage());
            }
        }
    }

    @Override
    public void close() {
        LOGGER.debug("Closing {} build cache", (Object)this.role.getDisplayName());
        if (this.disabled) {
            LOGGER.warn("The {} build cache was disabled during the build due to errors.", (Object)this.role.getDisplayName());
        }
        try {
            this.service.close();
        }
        catch (Exception e2) {
            if (this.logStackTraces) {
                LOGGER.warn("Error closing {} build cache: ", (Object)this.role.getDisplayName(), (Object)e2);
            }
            LOGGER.warn("Error closing {} build cache: {}", (Object)this.role.getDisplayName(), (Object)e2.getMessage());
        }
    }
}

