/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.controller.service;

import com.gradle.maven.extension.internal.dep.com.google.common.io.Closer;
import com.gradle.maven.extension.internal.dep.com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.gradle.caching.BuildCacheEntryWriter;

public class StoreTarget
implements BuildCacheEntryWriter {
    private final File file;
    private boolean stored;

    public StoreTarget(File file) {
        this.file = file;
    }

    @Override
    public void writeTo(OutputStream output) throws IOException {
        Closer closer = Closer.create();
        closer.register(output);
        try {
            if (this.stored) {
                throw new IllegalStateException("Build cache entry has already been stored");
            }
            this.stored = true;
            Files.asByteSource(this.file).copyTo(output);
        }
        catch (Exception e2) {
            throw closer.rethrow(e2);
        }
        finally {
            closer.close();
        }
    }

    public boolean isStored() {
        return this.stored;
    }

    @Override
    public long getSize() {
        return this.file.length();
    }
}

