/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.hash;

import com.gradle.maven.extension.internal.dep.com.google.common.base.Preconditions;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.hash.HashFunction;
import org.gradle.internal.hash.PrimitiveHasher;

public final class HashingOutputStream
extends FilterOutputStream {
    private final PrimitiveHasher hasher;

    public HashingOutputStream(HashFunction hashFunction, OutputStream out) {
        super(Preconditions.checkNotNull(out));
        this.hasher = Preconditions.checkNotNull(hashFunction.newPrimitiveHasher());
    }

    @Override
    public void write(int b2) throws IOException {
        this.hasher.putByte((byte)b2);
        this.out.write(b2);
    }

    @Override
    public void write(byte[] bytes, int off, int len) throws IOException {
        this.hasher.putBytes(bytes, off, len);
        this.out.write(bytes, off, len);
    }

    public HashCode hash() {
        return this.hasher.hash();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

