/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.enterprise.testdistribution.launcher.protocol.message;

import com.gradle.enterprise.testdistribution.launcher.protocol.message.f;
import com.gradle.enterprise.testdistribution.launcher.protocol.message.v;
import com.gradle.nullability.Nullable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.immutables.value.Value;

@Value.Immutable
public abstract class ao {
    public static final Class<? extends ao> TYPE = v.class;

    public static ao from(Throwable throwable) {
        return ao.from(throwable, true);
    }

    private static ao from(Throwable throwable, boolean includeAttributeExceptions) {
        return Objects.requireNonNull(ao.from(throwable, includeAttributeExceptions, Collections.newSetFromMap(new IdentityHashMap())));
    }

    @Nullable
    private static ao from(@Nullable Throwable throwable, boolean includeAttributeExceptions, Set<Throwable> dejaVu) {
        if (throwable == null || !dejaVu.add(throwable)) {
            return null;
        }
        return ao.create(throwable.getClass().getName(), throwable instanceof AssertionError, a.from(includeAttributeExceptions, throwable::getMessage), a.from(includeAttributeExceptions, throwable::toString), a.from(includeAttributeExceptions, () -> ao.from(throwable.getCause(), includeAttributeExceptions, dejaVu)), Stream.of(throwable.getSuppressed()).map(suppressed -> ao.from(suppressed, includeAttributeExceptions, dejaVu)).filter(Objects::nonNull).collect(Collectors.toList()), ao.readStackTraceSafely(throwable));
    }

    private static StackTraceElement[] readStackTraceSafely(Throwable throwable) {
        try {
            StackTraceElement[] stackTrace = throwable.getStackTrace();
            return stackTrace == null ? new StackTraceElement[]{} : stackTrace;
        }
        catch (RuntimeException ignore) {
            return new StackTraceElement[0];
        }
    }

    private static ao create(String originalClassName, boolean assertionError, a<String> message, a<String> stringRepresentation, a<ao> cause, List<ao> suppressed, StackTraceElement[] stackTrace) {
        return v.of(originalClassName, assertionError, message, stringRepresentation, cause, suppressed, Arrays.asList(stackTrace));
    }

    public abstract String getOriginalClassName();

    public abstract boolean isAssertionError();

    public abstract a<String> getMessage();

    public abstract a<String> getStringRepresentation();

    public abstract a<ao> getCause();

    public abstract List<ao> getSuppressed();

    public abstract List<StackTraceElement> getStackTrace();

    public StackTraceElement[] getStackTraceAsArray() {
        return this.getStackTrace().toArray(new StackTraceElement[0]);
    }

    public String toString() {
        return "ThrowablePlaceholder{originalClassName='" + this.getOriginalClassName() + '\'' + ", message=" + this.getMessage() + ", cause=" + this.getCause() + '}';
    }

    public String formatStackTrace() {
        StringWriter stringWriter = new StringWriter();
        try (PrintWriter writer = new PrintWriter(stringWriter);){
            this.printStackTrace(writer);
        }
        return stringWriter.toString();
    }

    public void printStackTrace(PrintWriter writer) {
        this.printEnclosedStackTrace(writer, new StackTraceElement[0], "", "");
    }

    private void printEnclosedStackTrace(PrintWriter s2, StackTraceElement[] enclosingTrace, String caption, String prefix) {
        StackTraceElement[] trace = this.getStackTraceAsArray();
        int m2 = trace.length - 1;
        for (int n2 = enclosingTrace.length - 1; m2 >= 0 && n2 >= 0 && trace[m2].equals(enclosingTrace[n2]); --m2, --n2) {
        }
        int framesInCommon = trace.length - 1 - m2;
        String toString = this.getStringRepresentation().getValue() != null ? this.getStringRepresentation().getValue() : this.getOriginalClassName();
        s2.println(prefix + caption + toString);
        for (int i2 = 0; i2 <= m2; ++i2) {
            s2.println(prefix + "\tat " + trace[i2]);
        }
        if (framesInCommon != 0) {
            s2.println(prefix + "\t... " + framesInCommon + " more");
        }
        for (ao suppressed : this.getSuppressed()) {
            suppressed.printEnclosedStackTrace(s2, trace, "Suppressed: ", "\t");
        }
        if (this.getCause().getValue() != null) {
            this.getCause().getValue().printEnclosedStackTrace(s2, trace, "Caused by: ", "");
        }
    }

    @Nullable
    public static Throwable convert(@Nullable ao placeholder, b factory) {
        return placeholder == null ? null : placeholder.convert(factory);
    }

    public Throwable convert(b factory) {
        Throwable throwable = factory.create(this.isAssertionError(), this.getOriginalClassName(), this.getMessage().getValue(), ao.convert(this.getMessage().getException(), factory), this.getStringRepresentation().getValue(), ao.convert(this.getStringRepresentation().getException(), factory), ao.convert(this.getCause().getValue(), factory));
        this.getSuppressed().forEach(it -> throwable.addSuppressed(it.convert(factory)));
        throwable.setStackTrace(this.getStackTraceAsArray());
        return throwable;
    }

    public static interface b {
        public Throwable create(boolean var1, String var2, @Nullable String var3, @Nullable Throwable var4, @Nullable String var5, @Nullable Throwable var6, @Nullable Throwable var7);
    }

    @Value.Immutable
    public static abstract class a<T> {
        public static final Class<? extends a> TYPE = f.class;

        private static <T> a<T> from(boolean includeException, Supplier<T> supplier) {
            T value;
            ao exception;
            block2: {
                exception = null;
                try {
                    value = supplier.get();
                }
                catch (RuntimeException e2) {
                    value = null;
                    if (!includeException) break block2;
                    exception = ao.from(e2, false);
                }
            }
            return a.create(value, exception);
        }

        private static <T> a<T> create(@Nullable T value, @Nullable ao exception) {
            return f.of(value, exception);
        }

        @Nullable
        public abstract T getValue();

        @Nullable
        public abstract ao getException();
    }
}

