/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.websocket.api.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class QuoteUtil {
    private static final char[] escapes = new char[32];

    public static String dequote(String str) {
        char end;
        char start = str.charAt(0);
        if ((start == '\'' || start == '\"') && start == (end = str.charAt(str.length() - 1))) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    public static void escape(StringBuilder buf, String str) {
        for (char c2 : str.toCharArray()) {
            if (c2 >= ' ') {
                if (c2 == '\"' || c2 == '\\') {
                    buf.append('\\');
                }
                buf.append(c2);
                continue;
            }
            char escaped = escapes[c2];
            if (escaped == '\uffff') {
                buf.append("\\u00");
                if (c2 < '\u0010') {
                    buf.append('0');
                }
                buf.append(Integer.toString(c2, 16));
                continue;
            }
            buf.append('\\').append(escaped);
        }
    }

    public static void quote(StringBuilder buf, String str) {
        buf.append('\"');
        QuoteUtil.escape(buf, str);
        buf.append('\"');
    }

    public static void quoteIfNeeded(StringBuilder buf, String str, String delim) {
        if (str == null) {
            return;
        }
        int len = str.length();
        if (len == 0) {
            return;
        }
        for (int i2 = 0; i2 < len; ++i2) {
            int ch2 = str.codePointAt(i2);
            if (delim.indexOf(ch2) < 0) continue;
            QuoteUtil.quote(buf, str);
            return;
        }
        buf.append(str);
    }

    public static Iterator<String> splitAt(String str, String delims) {
        return new DeQuotingStringIterator(str.trim(), delims);
    }

    static {
        Arrays.fill(escapes, '\uffff');
        QuoteUtil.escapes[8] = 98;
        QuoteUtil.escapes[9] = 116;
        QuoteUtil.escapes[10] = 110;
        QuoteUtil.escapes[12] = 102;
        QuoteUtil.escapes[13] = 114;
    }

    private static class DeQuotingStringIterator
    implements Iterator<String> {
        private final String input;
        private final String delims;
        private StringBuilder token;
        private boolean hasToken = false;
        private int i = 0;

        public DeQuotingStringIterator(String input, String delims) {
            this.input = input;
            this.delims = delims;
            int len = input.length();
            this.token = new StringBuilder(len > 1024 ? 512 : len / 2);
        }

        private void appendToken(char c2) {
            if (this.hasToken) {
                this.token.append(c2);
            } else {
                if (Character.isWhitespace(c2)) {
                    return;
                }
                this.token.append(c2);
                this.hasToken = true;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.hasToken) {
                return true;
            }
            State state = State.START;
            boolean escape = false;
            int inputLen = this.input.length();
            while (this.i < inputLen) {
                char c2 = this.input.charAt(this.i++);
                switch (state) {
                    case START: {
                        if (c2 == '\'') {
                            state = State.QUOTE_SINGLE;
                            this.appendToken(c2);
                            break;
                        }
                        if (c2 == '\"') {
                            state = State.QUOTE_DOUBLE;
                            this.appendToken(c2);
                            break;
                        }
                        this.appendToken(c2);
                        state = State.TOKEN;
                        break;
                    }
                    case TOKEN: {
                        if (this.delims.indexOf(c2) >= 0) {
                            return this.hasToken;
                        }
                        if (c2 == '\'') {
                            state = State.QUOTE_SINGLE;
                        } else if (c2 == '\"') {
                            state = State.QUOTE_DOUBLE;
                        }
                        this.appendToken(c2);
                        break;
                    }
                    case QUOTE_SINGLE: {
                        if (escape) {
                            escape = false;
                            this.appendToken(c2);
                            break;
                        }
                        if (c2 == '\'') {
                            this.appendToken(c2);
                            state = State.TOKEN;
                            break;
                        }
                        if (c2 == '\\') {
                            escape = true;
                            break;
                        }
                        this.appendToken(c2);
                        break;
                    }
                    case QUOTE_DOUBLE: {
                        if (escape) {
                            escape = false;
                            this.appendToken(c2);
                            break;
                        }
                        if (c2 == '\"') {
                            this.appendToken(c2);
                            state = State.TOKEN;
                            break;
                        }
                        if (c2 == '\\') {
                            escape = true;
                            break;
                        }
                        this.appendToken(c2);
                    }
                }
            }
            return this.hasToken;
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String ret = this.token.toString();
            this.token.setLength(0);
            this.hasToken = false;
            return QuoteUtil.dequote(ret.trim());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported with this iterator");
        }

        private static enum State {
            START,
            TOKEN,
            QUOTE_SINGLE,
            QUOTE_DOUBLE;

        }
    }
}

