/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.testdistribution.extension;

import com.gradle.maven.testdistribution.extension.TestDistributionGoalConfiguration;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.immutables.value.Generated;

@Generated(from="TestDistributionGoalConfiguration", generator="Immutables")
@SuppressFBWarnings
final class ImmutableTestDistributionGoalConfiguration
implements TestDistributionGoalConfiguration {
    private final boolean enabled;
    private final Integer maxLocalExecutors;
    private final Integer maxRemoteExecutors;
    private final Long preferredMaxDurationInMillis;
    private final Set<String> requirements;
    private final Integer waitTimeoutInSeconds;
    private final Integer forkedVMShutdownTimeoutInSeconds;

    private ImmutableTestDistributionGoalConfiguration() {
        this.enabled = false;
        this.maxLocalExecutors = null;
        this.maxRemoteExecutors = null;
        this.preferredMaxDurationInMillis = null;
        this.requirements = null;
        this.waitTimeoutInSeconds = null;
        this.forkedVMShutdownTimeoutInSeconds = null;
    }

    private ImmutableTestDistributionGoalConfiguration(boolean enabled, Integer maxLocalExecutors, Integer maxRemoteExecutors, Long preferredMaxDurationInMillis, Iterable<String> requirements, Integer waitTimeoutInSeconds, Integer forkedVMShutdownTimeoutInSeconds) {
        this.enabled = enabled;
        this.maxLocalExecutors = maxLocalExecutors;
        this.maxRemoteExecutors = maxRemoteExecutors;
        this.preferredMaxDurationInMillis = preferredMaxDurationInMillis;
        this.requirements = ImmutableTestDistributionGoalConfiguration.createUnmodifiableSet(ImmutableTestDistributionGoalConfiguration.createSafeList(requirements, true, false));
        this.waitTimeoutInSeconds = waitTimeoutInSeconds;
        this.forkedVMShutdownTimeoutInSeconds = forkedVMShutdownTimeoutInSeconds;
    }

    private ImmutableTestDistributionGoalConfiguration(ImmutableTestDistributionGoalConfiguration original, boolean enabled, Integer maxLocalExecutors, Integer maxRemoteExecutors, Long preferredMaxDurationInMillis, Set<String> requirements, Integer waitTimeoutInSeconds, Integer forkedVMShutdownTimeoutInSeconds) {
        this.enabled = enabled;
        this.maxLocalExecutors = maxLocalExecutors;
        this.maxRemoteExecutors = maxRemoteExecutors;
        this.preferredMaxDurationInMillis = preferredMaxDurationInMillis;
        this.requirements = requirements;
        this.waitTimeoutInSeconds = waitTimeoutInSeconds;
        this.forkedVMShutdownTimeoutInSeconds = forkedVMShutdownTimeoutInSeconds;
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public Integer getMaxLocalExecutors() {
        return this.maxLocalExecutors;
    }

    @Override
    public Integer getMaxRemoteExecutors() {
        return this.maxRemoteExecutors;
    }

    @Override
    public Long getPreferredMaxDurationInMillis() {
        return this.preferredMaxDurationInMillis;
    }

    @Override
    public Set<String> getRequirements() {
        return this.requirements;
    }

    @Override
    public Integer getWaitTimeoutInSeconds() {
        return this.waitTimeoutInSeconds;
    }

    @Override
    public Integer getForkedVMShutdownTimeoutInSeconds() {
        return this.forkedVMShutdownTimeoutInSeconds;
    }

    public final ImmutableTestDistributionGoalConfiguration withEnabled(boolean value) {
        if (this.enabled == value) {
            return this;
        }
        return new ImmutableTestDistributionGoalConfiguration(this, value, this.maxLocalExecutors, this.maxRemoteExecutors, this.preferredMaxDurationInMillis, this.requirements, this.waitTimeoutInSeconds, this.forkedVMShutdownTimeoutInSeconds);
    }

    public final ImmutableTestDistributionGoalConfiguration withMaxLocalExecutors(Integer value) {
        if (Objects.equals(this.maxLocalExecutors, value)) {
            return this;
        }
        return new ImmutableTestDistributionGoalConfiguration(this, this.enabled, value, this.maxRemoteExecutors, this.preferredMaxDurationInMillis, this.requirements, this.waitTimeoutInSeconds, this.forkedVMShutdownTimeoutInSeconds);
    }

    public final ImmutableTestDistributionGoalConfiguration withMaxRemoteExecutors(Integer value) {
        if (Objects.equals(this.maxRemoteExecutors, value)) {
            return this;
        }
        return new ImmutableTestDistributionGoalConfiguration(this, this.enabled, this.maxLocalExecutors, value, this.preferredMaxDurationInMillis, this.requirements, this.waitTimeoutInSeconds, this.forkedVMShutdownTimeoutInSeconds);
    }

    public final ImmutableTestDistributionGoalConfiguration withPreferredMaxDurationInMillis(Long value) {
        if (Objects.equals(this.preferredMaxDurationInMillis, value)) {
            return this;
        }
        return new ImmutableTestDistributionGoalConfiguration(this, this.enabled, this.maxLocalExecutors, this.maxRemoteExecutors, value, this.requirements, this.waitTimeoutInSeconds, this.forkedVMShutdownTimeoutInSeconds);
    }

    public final ImmutableTestDistributionGoalConfiguration withRequirements(String ... elements) {
        Set<String> newValue = ImmutableTestDistributionGoalConfiguration.createUnmodifiableSet(ImmutableTestDistributionGoalConfiguration.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableTestDistributionGoalConfiguration(this, this.enabled, this.maxLocalExecutors, this.maxRemoteExecutors, this.preferredMaxDurationInMillis, newValue, this.waitTimeoutInSeconds, this.forkedVMShutdownTimeoutInSeconds);
    }

    public final ImmutableTestDistributionGoalConfiguration withRequirements(Iterable<String> elements) {
        if (this.requirements == elements) {
            return this;
        }
        Set<String> newValue = ImmutableTestDistributionGoalConfiguration.createUnmodifiableSet(ImmutableTestDistributionGoalConfiguration.createSafeList(elements, true, false));
        return new ImmutableTestDistributionGoalConfiguration(this, this.enabled, this.maxLocalExecutors, this.maxRemoteExecutors, this.preferredMaxDurationInMillis, newValue, this.waitTimeoutInSeconds, this.forkedVMShutdownTimeoutInSeconds);
    }

    public final ImmutableTestDistributionGoalConfiguration withWaitTimeoutInSeconds(Integer value) {
        if (Objects.equals(this.waitTimeoutInSeconds, value)) {
            return this;
        }
        return new ImmutableTestDistributionGoalConfiguration(this, this.enabled, this.maxLocalExecutors, this.maxRemoteExecutors, this.preferredMaxDurationInMillis, this.requirements, value, this.forkedVMShutdownTimeoutInSeconds);
    }

    public final ImmutableTestDistributionGoalConfiguration withForkedVMShutdownTimeoutInSeconds(Integer value) {
        if (Objects.equals(this.forkedVMShutdownTimeoutInSeconds, value)) {
            return this;
        }
        return new ImmutableTestDistributionGoalConfiguration(this, this.enabled, this.maxLocalExecutors, this.maxRemoteExecutors, this.preferredMaxDurationInMillis, this.requirements, this.waitTimeoutInSeconds, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTestDistributionGoalConfiguration && this.equalTo((ImmutableTestDistributionGoalConfiguration)another);
    }

    private boolean equalTo(ImmutableTestDistributionGoalConfiguration another) {
        return this.enabled == another.enabled && Objects.equals(this.maxLocalExecutors, another.maxLocalExecutors) && Objects.equals(this.maxRemoteExecutors, another.maxRemoteExecutors) && Objects.equals(this.preferredMaxDurationInMillis, another.preferredMaxDurationInMillis) && this.requirements.equals(another.requirements) && Objects.equals(this.waitTimeoutInSeconds, another.waitTimeoutInSeconds) && Objects.equals(this.forkedVMShutdownTimeoutInSeconds, another.forkedVMShutdownTimeoutInSeconds);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Boolean.hashCode(this.enabled);
        h2 += (h2 << 5) + Objects.hashCode(this.maxLocalExecutors);
        h2 += (h2 << 5) + Objects.hashCode(this.maxRemoteExecutors);
        h2 += (h2 << 5) + Objects.hashCode(this.preferredMaxDurationInMillis);
        h2 += (h2 << 5) + this.requirements.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.waitTimeoutInSeconds);
        h2 += (h2 << 5) + Objects.hashCode(this.forkedVMShutdownTimeoutInSeconds);
        return h2;
    }

    public String toString() {
        return "TestDistributionGoalConfiguration{enabled=" + this.enabled + ", maxLocalExecutors=" + this.maxLocalExecutors + ", maxRemoteExecutors=" + this.maxRemoteExecutors + ", preferredMaxDurationInMillis=" + this.preferredMaxDurationInMillis + ", requirements=" + this.requirements + ", waitTimeoutInSeconds=" + this.waitTimeoutInSeconds + ", forkedVMShutdownTimeoutInSeconds=" + this.forkedVMShutdownTimeoutInSeconds + "}";
    }

    public static TestDistributionGoalConfiguration of(boolean enabled, Integer maxLocalExecutors, Integer maxRemoteExecutors, Long preferredMaxDurationInMillis, Set<String> requirements, Integer waitTimeoutInSeconds, Integer forkedVMShutdownTimeoutInSeconds) {
        return ImmutableTestDistributionGoalConfiguration.of(enabled, maxLocalExecutors, maxRemoteExecutors, preferredMaxDurationInMillis, requirements, waitTimeoutInSeconds, forkedVMShutdownTimeoutInSeconds);
    }

    public static TestDistributionGoalConfiguration of(boolean enabled, Integer maxLocalExecutors, Integer maxRemoteExecutors, Long preferredMaxDurationInMillis, Iterable<String> requirements, Integer waitTimeoutInSeconds, Integer forkedVMShutdownTimeoutInSeconds) {
        return new ImmutableTestDistributionGoalConfiguration(enabled, maxLocalExecutors, maxRemoteExecutors, preferredMaxDurationInMillis, requirements, waitTimeoutInSeconds, forkedVMShutdownTimeoutInSeconds);
    }

    public static TestDistributionGoalConfiguration copyOf(TestDistributionGoalConfiguration instance) {
        if (instance instanceof ImmutableTestDistributionGoalConfiguration) {
            return (ImmutableTestDistributionGoalConfiguration)instance;
        }
        return ImmutableTestDistributionGoalConfiguration.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size());
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    @Generated(from="TestDistributionGoalConfiguration", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_ENABLED = 1L;
        private long initBits = 1L;
        private boolean enabled;
        private Integer maxLocalExecutors;
        private Integer maxRemoteExecutors;
        private Long preferredMaxDurationInMillis;
        private List<String> requirements = new ArrayList<String>();
        private Integer waitTimeoutInSeconds;
        private Integer forkedVMShutdownTimeoutInSeconds;

        private Builder() {
        }

        public final Builder from(TestDistributionGoalConfiguration instance) {
            Integer forkedVMShutdownTimeoutInSecondsValue;
            Long preferredMaxDurationInMillisValue;
            Integer maxRemoteExecutorsValue;
            Objects.requireNonNull(instance, "instance");
            this.setEnabled(instance.enabled());
            Integer maxLocalExecutorsValue = instance.getMaxLocalExecutors();
            if (maxLocalExecutorsValue != null) {
                this.setMaxLocalExecutors(maxLocalExecutorsValue);
            }
            if ((maxRemoteExecutorsValue = instance.getMaxRemoteExecutors()) != null) {
                this.setMaxRemoteExecutors(maxRemoteExecutorsValue);
            }
            if ((preferredMaxDurationInMillisValue = instance.getPreferredMaxDurationInMillis()) != null) {
                this.setPreferredMaxDurationInMillis(preferredMaxDurationInMillisValue);
            }
            this.addAllRequirements(instance.getRequirements());
            Integer waitTimeoutInSecondsValue = instance.getWaitTimeoutInSeconds();
            if (waitTimeoutInSecondsValue != null) {
                this.setWaitTimeoutInSeconds(waitTimeoutInSecondsValue);
            }
            if ((forkedVMShutdownTimeoutInSecondsValue = instance.getForkedVMShutdownTimeoutInSeconds()) != null) {
                this.setForkedVMShutdownTimeoutInSeconds(forkedVMShutdownTimeoutInSecondsValue);
            }
            return this;
        }

        public final Builder setEnabled(boolean enabled) {
            this.enabled = enabled;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setMaxLocalExecutors(Integer maxLocalExecutors) {
            this.maxLocalExecutors = maxLocalExecutors;
            return this;
        }

        public final Builder setMaxRemoteExecutors(Integer maxRemoteExecutors) {
            this.maxRemoteExecutors = maxRemoteExecutors;
            return this;
        }

        public final Builder setPreferredMaxDurationInMillis(Long preferredMaxDurationInMillis) {
            this.preferredMaxDurationInMillis = preferredMaxDurationInMillis;
            return this;
        }

        public final Builder addRequirements(String element) {
            this.requirements.add(Objects.requireNonNull(element, "requirements element"));
            return this;
        }

        public final Builder addRequirements(String ... elements) {
            for (String element : elements) {
                this.requirements.add(Objects.requireNonNull(element, "requirements element"));
            }
            return this;
        }

        public final Builder setRequirements(Iterable<String> elements) {
            this.requirements.clear();
            return this.addAllRequirements(elements);
        }

        public final Builder addAllRequirements(Iterable<String> elements) {
            for (String element : elements) {
                this.requirements.add(Objects.requireNonNull(element, "requirements element"));
            }
            return this;
        }

        public final Builder setWaitTimeoutInSeconds(Integer waitTimeoutInSeconds) {
            this.waitTimeoutInSeconds = waitTimeoutInSeconds;
            return this;
        }

        public final Builder setForkedVMShutdownTimeoutInSeconds(Integer forkedVMShutdownTimeoutInSeconds) {
            this.forkedVMShutdownTimeoutInSeconds = forkedVMShutdownTimeoutInSeconds;
            return this;
        }

        public TestDistributionGoalConfiguration build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTestDistributionGoalConfiguration(null, this.enabled, this.maxLocalExecutors, this.maxRemoteExecutors, this.preferredMaxDurationInMillis, ImmutableTestDistributionGoalConfiguration.createUnmodifiableSet(this.requirements), this.waitTimeoutInSeconds, this.forkedVMShutdownTimeoutInSeconds);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("enabled");
            }
            return "Cannot build TestDistributionGoalConfiguration, some of required attributes are not set " + attributes;
        }
    }
}

