/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.apache.http.message;

import com.gradle.maven.extension.internal.dep.org.apache.http.NameValuePair;
import com.gradle.maven.extension.internal.dep.org.apache.http.util.Args;
import com.gradle.maven.extension.internal.dep.org.apache.http.util.CharArrayBuffer;

public class BasicHeaderValueFormatter {
    @Deprecated
    public static final BasicHeaderValueFormatter DEFAULT = new BasicHeaderValueFormatter();
    public static final BasicHeaderValueFormatter INSTANCE = new BasicHeaderValueFormatter();

    public CharArrayBuffer formatParameters(CharArrayBuffer charBuffer, NameValuePair[] nvps, boolean quote) {
        Args.notNull(nvps, "Header parameter array");
        int len = this.estimateParametersLen(nvps);
        CharArrayBuffer buffer = charBuffer;
        if (buffer == null) {
            buffer = new CharArrayBuffer(len);
        } else {
            buffer.ensureCapacity(len);
        }
        for (int i2 = 0; i2 < nvps.length; ++i2) {
            if (i2 > 0) {
                buffer.append("; ");
            }
            this.formatNameValuePair(buffer, nvps[i2], quote);
        }
        return buffer;
    }

    protected int estimateParametersLen(NameValuePair[] nvps) {
        if (nvps == null || nvps.length < 1) {
            return 0;
        }
        int result = (nvps.length - 1) * 2;
        for (NameValuePair nvp : nvps) {
            result += this.estimateNameValuePairLen(nvp);
        }
        return result;
    }

    public CharArrayBuffer formatNameValuePair(CharArrayBuffer charBuffer, NameValuePair nvp, boolean quote) {
        Args.notNull(nvp, "Name / value pair");
        int len = this.estimateNameValuePairLen(nvp);
        CharArrayBuffer buffer = charBuffer;
        if (buffer == null) {
            buffer = new CharArrayBuffer(len);
        } else {
            buffer.ensureCapacity(len);
        }
        buffer.append(nvp.getName());
        String value = nvp.getValue();
        if (value != null) {
            buffer.append('=');
            this.doFormatValue(buffer, value, quote);
        }
        return buffer;
    }

    protected int estimateNameValuePairLen(NameValuePair nvp) {
        if (nvp == null) {
            return 0;
        }
        int result = nvp.getName().length();
        String value = nvp.getValue();
        if (value != null) {
            result += 3 + value.length();
        }
        return result;
    }

    protected void doFormatValue(CharArrayBuffer buffer, String value, boolean quote) {
        int i2;
        boolean quoteFlag = quote;
        if (!quoteFlag) {
            for (i2 = 0; i2 < value.length() && !quoteFlag; ++i2) {
                quoteFlag = this.isSeparator(value.charAt(i2));
            }
        }
        if (quoteFlag) {
            buffer.append('\"');
        }
        for (i2 = 0; i2 < value.length(); ++i2) {
            char ch2 = value.charAt(i2);
            if (this.isUnsafe(ch2)) {
                buffer.append('\\');
            }
            buffer.append(ch2);
        }
        if (quoteFlag) {
            buffer.append('\"');
        }
    }

    protected boolean isSeparator(char ch2) {
        return " ;,:@()<>\\\"/[]?={}\t".indexOf(ch2) >= 0;
    }

    protected boolean isUnsafe(char ch2) {
        return "\"\\".indexOf(ch2) >= 0;
    }
}

