/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.codehaus.plexus.languages.java.jpms;

import com.gradle.maven.extension.internal.dep.org.codehaus.plexus.languages.java.jpms.BinaryModuleInfoParser;
import com.gradle.maven.extension.internal.dep.org.codehaus.plexus.languages.java.jpms.CmdModuleNameExtractor;
import com.gradle.maven.extension.internal.dep.org.codehaus.plexus.languages.java.jpms.JavaModuleDescriptor;
import com.gradle.maven.extension.internal.dep.org.codehaus.plexus.languages.java.jpms.MainClassModuleNameExtractor;
import com.gradle.maven.extension.internal.dep.org.codehaus.plexus.languages.java.jpms.ManifestModuleNameExtractor;
import com.gradle.maven.extension.internal.dep.org.codehaus.plexus.languages.java.jpms.ModuleInfoParser;
import com.gradle.maven.extension.internal.dep.org.codehaus.plexus.languages.java.jpms.ModuleNameExtractor;
import com.gradle.maven.extension.internal.dep.org.codehaus.plexus.languages.java.jpms.ModuleNameSource;
import com.gradle.maven.extension.internal.dep.org.codehaus.plexus.languages.java.jpms.ResolvePathRequest;
import com.gradle.maven.extension.internal.dep.org.codehaus.plexus.languages.java.jpms.ResolvePathResult;
import com.gradle.maven.extension.internal.dep.org.codehaus.plexus.languages.java.jpms.ResolvePathsRequest;
import com.gradle.maven.extension.internal.dep.org.codehaus.plexus.languages.java.jpms.ResolvePathsResult;
import com.gradle.maven.extension.internal.dep.org.codehaus.plexus.languages.java.jpms.SourceModuleInfoParser;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Singleton;

@Named
@Singleton
public class LocationManager {
    private ModuleInfoParser binaryParser = new BinaryModuleInfoParser();
    private SourceModuleInfoParser sourceParser = new SourceModuleInfoParser();
    private ManifestModuleNameExtractor manifestModuleNameExtractor = new ManifestModuleNameExtractor();

    public <T> ResolvePathResult resolvePath(final ResolvePathRequest<T> request) throws IOException {
        ModuleNameExtractor filenameExtractor = new ModuleNameExtractor(){
            MainClassModuleNameExtractor extractor;
            {
                this.extractor = new MainClassModuleNameExtractor(request.getJdkHome());
            }

            @Override
            public String extract(Path file) throws IOException {
                if (request.getJdkHome() != null) {
                    return this.extractor.extract(Collections.singletonMap(file, file)).get(file);
                }
                return CmdModuleNameExtractor.getModuleName(file);
            }
        };
        return this.resolvePath(request.toPath(request.getPathElement()), filenameExtractor);
    }

    public <T> ResolvePathsResult<T> resolvePaths(final ResolvePathsRequest<T> request) throws IOException {
        ResolvePathsResult result = request.createResult();
        LinkedHashMap<Object, Object> pathElements = new LinkedHashMap<Object, Object>(request.getPathElements().size());
        JavaModuleDescriptor mainModuleDescriptor = this.getMainModuleDescriptor(request);
        result.setMainModuleDescriptor(mainModuleDescriptor);
        HashMap<String, Set<String>> availableProviders = new HashMap<String, Set<String>>();
        if (mainModuleDescriptor != null && request.isIncludeAllProviders()) {
            this.collectProviders(mainModuleDescriptor, availableProviders);
        }
        HashMap<String, Object> availableNamedModules = new HashMap<String, Object>();
        HashMap<String, ModuleNameSource> moduleNameSources = new HashMap<String, ModuleNameSource>();
        final HashMap filenameAutoModules = new HashMap();
        for (final T t2 : request.getPathElements()) {
            ModuleNameSource source;
            JavaModuleDescriptor moduleDescriptor;
            ModuleNameExtractor nameExtractor = new ModuleNameExtractor(){

                @Override
                public String extract(Path path) throws IOException {
                    if (request.getJdkHome() == null) {
                        return CmdModuleNameExtractor.getModuleName(path);
                    }
                    filenameAutoModules.put(t2, path);
                    return null;
                }
            };
            try {
                ResolvePathResult resolvedPath = this.resolvePath(request.toPath(t2), nameExtractor);
                moduleDescriptor = resolvedPath.getModuleDescriptor();
                source = resolvedPath.getModuleNameSource();
            }
            catch (Exception e2) {
                result.getPathExceptions().put(t2, e2);
                continue;
            }
            if (moduleDescriptor != null && moduleNameSources.putIfAbsent(moduleDescriptor.name(), source) == null) {
                availableNamedModules.put(moduleDescriptor.name(), moduleDescriptor);
                if (request.isIncludeAllProviders()) {
                    this.collectProviders(moduleDescriptor, availableProviders);
                }
            }
            pathElements.put(t2, moduleDescriptor);
        }
        result.setPathElements(pathElements);
        if (!filenameAutoModules.isEmpty()) {
            MainClassModuleNameExtractor extractor = new MainClassModuleNameExtractor(request.getJdkHome());
            Map automodules = extractor.extract(filenameAutoModules);
            for (Map.Entry entry : automodules.entrySet()) {
                String moduleName = (String)entry.getValue();
                if (moduleName == null) continue;
                JavaModuleDescriptor moduleDescriptor = JavaModuleDescriptor.newAutomaticModule(moduleName).build();
                moduleNameSources.put(moduleDescriptor.name(), ModuleNameSource.FILENAME);
                availableNamedModules.put(moduleDescriptor.name(), moduleDescriptor);
                pathElements.put(entry.getKey(), moduleDescriptor);
            }
        }
        HashSet<String> requiredNamedModules = new HashSet<String>();
        if (mainModuleDescriptor != null) {
            requiredNamedModules.add(mainModuleDescriptor.name());
            this.selectRequires(mainModuleDescriptor, Collections.unmodifiableMap(availableNamedModules), Collections.unmodifiableMap(availableProviders), requiredNamedModules, true);
        }
        for (String additionalModule : request.getAdditionalModules()) {
            this.selectModule(additionalModule, Collections.unmodifiableMap(availableNamedModules), Collections.unmodifiableMap(availableProviders), requiredNamedModules, request.isIncludeStatic());
        }
        HashSet<String> collectedModules = new HashSet<String>(requiredNamedModules.size());
        for (Map.Entry entry : pathElements.entrySet()) {
            if (entry.getValue() != null && requiredNamedModules.contains(((JavaModuleDescriptor)entry.getValue()).name())) {
                if (!collectedModules.add(((JavaModuleDescriptor)entry.getValue()).name())) continue;
                result.getModulepathElements().put((T)entry.getKey(), (ModuleNameSource)((Object)moduleNameSources.get(((JavaModuleDescriptor)entry.getValue()).name())));
                continue;
            }
            result.getClasspathElements().add(entry.getKey());
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> JavaModuleDescriptor getMainModuleDescriptor(ResolvePathsRequest<T> request) throws IOException {
        Path descriptorPath = request.getMainModuleDescriptor();
        if (descriptorPath == null) return request.getModuleDescriptor();
        if (descriptorPath.endsWith("module-info.java")) {
            return this.sourceParser.fromSourcePath(descriptorPath);
        }
        if (!descriptorPath.endsWith("module-info.class")) throw new IOException("Invalid path to module descriptor: " + descriptorPath);
        return this.binaryParser.getModuleDescriptor(descriptorPath.getParent());
    }

    private ResolvePathResult resolvePath(Path path, ModuleNameExtractor fileModulenameExtractor) throws IOException {
        ResolvePathResult result = new ResolvePathResult();
        JavaModuleDescriptor moduleDescriptor = null;
        if (Files.isRegularFile(path, new LinkOption[0]) && !path.getFileName().toString().endsWith(".jar")) {
            throw new IllegalArgumentException("'" + path.toString() + "' not allowed on the path, only outputDirectories and jars are accepted");
        }
        if (Files.isRegularFile(path, new LinkOption[0]) || Files.exists(path.resolve("module-info.class"), new LinkOption[0])) {
            moduleDescriptor = this.binaryParser.getModuleDescriptor(path);
        }
        if (moduleDescriptor != null) {
            result.setModuleNameSource(ModuleNameSource.MODULEDESCRIPTOR);
        } else {
            String moduleName = this.manifestModuleNameExtractor.extract(path);
            if (moduleName != null) {
                result.setModuleNameSource(ModuleNameSource.MANIFEST);
            } else {
                moduleName = fileModulenameExtractor.extract(path);
                if (moduleName != null) {
                    result.setModuleNameSource(ModuleNameSource.FILENAME);
                }
            }
            if (moduleName != null) {
                moduleDescriptor = JavaModuleDescriptor.newAutomaticModule(moduleName).build();
            }
        }
        result.setModuleDescriptor(moduleDescriptor);
        return result;
    }

    private void selectRequires(JavaModuleDescriptor module, Map<String, JavaModuleDescriptor> availableModules, Map<String, Set<String>> availableProviders, Set<String> namedModules, boolean includeStatic) {
        for (JavaModuleDescriptor.JavaRequires requires : module.requires()) {
            if (!includeStatic && requires.modifiers().contains((Object)JavaModuleDescriptor.JavaRequires.JavaModifier.STATIC)) continue;
            this.selectModule(requires.name(), availableModules, availableProviders, namedModules, false);
        }
        for (String uses : module.uses()) {
            if (!availableProviders.containsKey(uses)) continue;
            for (String providerModule : availableProviders.get(uses)) {
                JavaModuleDescriptor requiredModule = availableModules.get(providerModule);
                if (requiredModule == null || !namedModules.add(providerModule)) continue;
                this.selectRequires(requiredModule, availableModules, availableProviders, namedModules, false);
            }
        }
    }

    private void selectModule(String module, Map<String, JavaModuleDescriptor> availableModules, Map<String, Set<String>> availableProviders, Set<String> namedModules, boolean includeStatic) {
        JavaModuleDescriptor requiredModule = availableModules.get(module);
        if (requiredModule != null && namedModules.add(module)) {
            this.selectRequires(requiredModule, availableModules, availableProviders, namedModules, includeStatic);
        }
    }

    private void collectProviders(JavaModuleDescriptor moduleDescriptor, Map<String, Set<String>> availableProviders) {
        for (JavaModuleDescriptor.JavaProvides provides : moduleDescriptor.provides()) {
            String serviceClassName = provides.service().replace('$', '.');
            Set<String> providingModules = availableProviders.get(serviceClassName);
            if (providingModules == null) {
                providingModules = new HashSet<String>();
                availableProviders.put(serviceClassName, providingModules);
            }
            providingModules.add(moduleDescriptor.name());
        }
    }
}

