/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.util;

import com.gradle.maven.extension.internal.dep.com.esotericsoftware.kryo.util.ObjectMap;

public class IntMap<V> {
    public int size;
    int[] keyTable;
    V[] valueTable;
    int capacity;
    int stashSize;
    V zeroValue;
    boolean hasZeroValue;
    private float loadFactor;
    private int hashShift;
    private int mask;
    private int threshold;
    private int stashCapacity;
    private int pushIterations;
    private boolean isBigTable;

    public IntMap() {
        this(32, 0.8f);
    }

    public IntMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initialCapacity must be >= 0: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            throw new IllegalArgumentException("initialCapacity is too large: " + initialCapacity);
        }
        this.capacity = ObjectMap.nextPowerOfTwo(initialCapacity);
        if (loadFactor <= 0.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0: " + loadFactor);
        }
        this.loadFactor = loadFactor;
        this.isBigTable = this.capacity >>> 16 != 0;
        this.threshold = (int)((float)this.capacity * loadFactor);
        this.mask = this.capacity - 1;
        this.hashShift = 31 - Integer.numberOfTrailingZeros(this.capacity);
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(this.capacity)) * 2);
        this.pushIterations = Math.max(Math.min(this.capacity, 8), (int)Math.sqrt(this.capacity) / 8);
        this.keyTable = new int[this.capacity + this.stashCapacity];
        this.valueTable = new Object[this.keyTable.length];
    }

    public V put(int key, V value) {
        int i2;
        if (key == 0) {
            V oldValue = this.zeroValue;
            this.zeroValue = value;
            if (!this.hasZeroValue) {
                this.hasZeroValue = true;
                ++this.size;
            }
            return oldValue;
        }
        int[] keyTable = this.keyTable;
        int mask = this.mask;
        boolean isBigTable = this.isBigTable;
        int index1 = key & mask;
        int key1 = keyTable[index1];
        if (key1 == key) {
            V oldValue = this.valueTable[index1];
            this.valueTable[index1] = value;
            return oldValue;
        }
        int index2 = this.hash2(key);
        int key2 = keyTable[index2];
        if (key2 == key) {
            V oldValue = this.valueTable[index2];
            this.valueTable[index2] = value;
            return oldValue;
        }
        int index3 = this.hash3(key);
        int key3 = keyTable[index3];
        if (key3 == key) {
            V oldValue = this.valueTable[index3];
            this.valueTable[index3] = value;
            return oldValue;
        }
        int index4 = -1;
        int key4 = -1;
        if (isBigTable && (key4 = keyTable[index4 = this.hash4(key)]) == key) {
            V oldValue = this.valueTable[index4];
            this.valueTable[index4] = value;
            return oldValue;
        }
        int n2 = i2 + this.stashSize;
        for (i2 = this.capacity; i2 < n2; ++i2) {
            if (keyTable[i2] != key) continue;
            V oldValue = this.valueTable[i2];
            this.valueTable[i2] = value;
            return oldValue;
        }
        if (key1 == 0) {
            keyTable[index1] = key;
            this.valueTable[index1] = value;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return null;
        }
        if (key2 == 0) {
            keyTable[index2] = key;
            this.valueTable[index2] = value;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return null;
        }
        if (key3 == 0) {
            keyTable[index3] = key;
            this.valueTable[index3] = value;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return null;
        }
        if (isBigTable && key4 == 0) {
            keyTable[index4] = key;
            this.valueTable[index4] = value;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return null;
        }
        this.push(key, value, index1, key1, index2, key2, index3, key3, index4, key4);
        return null;
    }

    private void putResize(int key, V value) {
        if (key == 0) {
            this.zeroValue = value;
            this.hasZeroValue = true;
            return;
        }
        int index1 = key & this.mask;
        int key1 = this.keyTable[index1];
        if (key1 == 0) {
            this.keyTable[index1] = key;
            this.valueTable[index1] = value;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        int index2 = this.hash2(key);
        int key2 = this.keyTable[index2];
        if (key2 == 0) {
            this.keyTable[index2] = key;
            this.valueTable[index2] = value;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        int index3 = this.hash3(key);
        int key3 = this.keyTable[index3];
        if (key3 == 0) {
            this.keyTable[index3] = key;
            this.valueTable[index3] = value;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        int index4 = -1;
        int key4 = -1;
        if (this.isBigTable && (key4 = this.keyTable[index4 = this.hash4(key)]) == 0) {
            this.keyTable[index4] = key;
            this.valueTable[index4] = value;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        this.push(key, value, index1, key1, index2, key2, index3, key3, index4, key4);
    }

    private void push(int insertKey, V insertValue, int index1, int key1, int index2, int key2, int index3, int key3, int index4, int key4) {
        V evictedValue;
        int evictedKey;
        int[] keyTable = this.keyTable;
        V[] valueTable = this.valueTable;
        int mask = this.mask;
        boolean isBigTable = this.isBigTable;
        int i2 = 0;
        int pushIterations = this.pushIterations;
        int n2 = isBigTable ? 4 : 3;
        while (true) {
            switch (ObjectMap.random.nextInt(n2)) {
                case 0: {
                    evictedKey = key1;
                    evictedValue = valueTable[index1];
                    keyTable[index1] = insertKey;
                    valueTable[index1] = insertValue;
                    break;
                }
                case 1: {
                    evictedKey = key2;
                    evictedValue = valueTable[index2];
                    keyTable[index2] = insertKey;
                    valueTable[index2] = insertValue;
                    break;
                }
                case 2: {
                    evictedKey = key3;
                    evictedValue = valueTable[index3];
                    keyTable[index3] = insertKey;
                    valueTable[index3] = insertValue;
                    break;
                }
                default: {
                    evictedKey = key4;
                    evictedValue = valueTable[index4];
                    keyTable[index4] = insertKey;
                    valueTable[index4] = insertValue;
                }
            }
            index1 = evictedKey & mask;
            key1 = keyTable[index1];
            if (key1 == 0) {
                keyTable[index1] = evictedKey;
                valueTable[index1] = evictedValue;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            index2 = this.hash2(evictedKey);
            key2 = keyTable[index2];
            if (key2 == 0) {
                keyTable[index2] = evictedKey;
                valueTable[index2] = evictedValue;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            index3 = this.hash3(evictedKey);
            key3 = keyTable[index3];
            if (key3 == 0) {
                keyTable[index3] = evictedKey;
                valueTable[index3] = evictedValue;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            if (isBigTable && (key4 = keyTable[index4 = this.hash4(evictedKey)]) == 0) {
                keyTable[index4] = evictedKey;
                valueTable[index4] = evictedValue;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            if (++i2 == pushIterations) break;
            insertKey = evictedKey;
            insertValue = evictedValue;
        }
        this.putStash(evictedKey, evictedValue);
    }

    private void putStash(int key, V value) {
        if (this.stashSize == this.stashCapacity) {
            this.resize(this.capacity << 1);
            this.put(key, value);
            return;
        }
        int index = this.capacity + this.stashSize;
        this.keyTable[index] = key;
        this.valueTable[index] = value;
        ++this.stashSize;
        ++this.size;
    }

    public V get(int key) {
        if (key == 0) {
            if (!this.hasZeroValue) {
                return null;
            }
            return this.zeroValue;
        }
        int index = key & this.mask;
        if (this.keyTable[index] != key && this.keyTable[index = this.hash2(key)] != key && this.keyTable[index = this.hash3(key)] != key) {
            if (this.isBigTable) {
                index = this.hash4(key);
                if (this.keyTable[index] != key) {
                    return this.getStash(key, null);
                }
            } else {
                return this.getStash(key, null);
            }
        }
        return this.valueTable[index];
    }

    private V getStash(int key, V defaultValue) {
        int i2;
        int[] keyTable = this.keyTable;
        int n2 = i2 + this.stashSize;
        for (i2 = this.capacity; i2 < n2; ++i2) {
            if (keyTable[i2] != key) continue;
            return this.valueTable[i2];
        }
        return defaultValue;
    }

    public void clear() {
        int[] keyTable = this.keyTable;
        V[] valueTable = this.valueTable;
        int i2 = this.capacity + this.stashSize;
        while (i2-- > 0) {
            keyTable[i2] = 0;
            valueTable[i2] = null;
        }
        this.size = 0;
        this.stashSize = 0;
        this.zeroValue = null;
        this.hasZeroValue = false;
    }

    private void resize(int newSize) {
        int oldEndIndex = this.capacity + this.stashSize;
        this.capacity = newSize;
        this.threshold = (int)((float)newSize * this.loadFactor);
        this.mask = newSize - 1;
        this.hashShift = 31 - Integer.numberOfTrailingZeros(newSize);
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(newSize)) * 2);
        this.pushIterations = Math.max(Math.min(newSize, 8), (int)Math.sqrt(newSize) / 8);
        this.isBigTable = this.capacity >>> 16 != 0;
        int[] oldKeyTable = this.keyTable;
        V[] oldValueTable = this.valueTable;
        this.keyTable = new int[newSize + this.stashCapacity];
        this.valueTable = new Object[newSize + this.stashCapacity];
        int oldSize = this.size;
        this.size = this.hasZeroValue ? 1 : 0;
        this.stashSize = 0;
        if (oldSize > 0) {
            for (int i2 = 0; i2 < oldEndIndex; ++i2) {
                int key = oldKeyTable[i2];
                if (key == 0) continue;
                this.putResize(key, oldValueTable[i2]);
            }
        }
    }

    private int hash2(int h2) {
        return ((h2 *= -1105259343) ^ h2 >>> this.hashShift) & this.mask;
    }

    private int hash3(int h2) {
        return ((h2 *= -1262997959) ^ h2 >>> this.hashShift) & this.mask;
    }

    private int hash4(int h2) {
        return ((h2 *= -825114047) ^ h2 >>> this.hashShift) & this.mask;
    }

    public String toString() {
        int key;
        if (this.size == 0) {
            return "[]";
        }
        StringBuilder buffer = new StringBuilder(32);
        buffer.append('[');
        int[] keyTable = this.keyTable;
        V[] valueTable = this.valueTable;
        int i2 = keyTable.length;
        if (this.hasZeroValue) {
            buffer.append("0=");
            buffer.append(this.zeroValue);
        } else {
            while (i2-- > 0) {
                key = keyTable[i2];
                if (key == 0) continue;
                buffer.append(key);
                buffer.append('=');
                buffer.append(valueTable[i2]);
                break;
            }
        }
        while (i2-- > 0) {
            key = keyTable[i2];
            if (key == 0) continue;
            buffer.append(", ");
            buffer.append(key);
            buffer.append('=');
            buffer.append(valueTable[i2]);
        }
        buffer.append(']');
        return buffer.toString();
    }
}

