/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.net.jodah.failsafe;

import com.gradle.maven.extension.internal.dep.net.jodah.failsafe.AbstractExecution;
import com.gradle.maven.extension.internal.dep.net.jodah.failsafe.DelayablePolicy;
import com.gradle.maven.extension.internal.dep.net.jodah.failsafe.PolicyExecutor;
import com.gradle.maven.extension.internal.dep.net.jodah.failsafe.RetryPolicyExecutor;
import com.gradle.maven.extension.internal.dep.net.jodah.failsafe.event.ExecutionAttemptedEvent;
import com.gradle.maven.extension.internal.dep.net.jodah.failsafe.function.CheckedConsumer;
import com.gradle.maven.extension.internal.dep.net.jodah.failsafe.internal.EventListener;
import com.gradle.maven.extension.internal.dep.net.jodah.failsafe.internal.util.Assert;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;

public class RetryPolicy<R>
extends DelayablePolicy<RetryPolicy<R>, R> {
    private Duration delay = Duration.ZERO;
    private Duration delayMin;
    private Duration delayMax;
    private double delayFactor;
    private Duration maxDelay;
    private Duration jitter;
    private double jitterFactor;
    private Duration maxDuration;
    private int maxRetries = 2;
    private List<BiPredicate<R, Throwable>> abortConditions = new ArrayList<BiPredicate<R, Throwable>>();
    private EventListener abortListener;
    private EventListener failedAttemptListener;
    private EventListener retriesExceededListener;
    private EventListener retryListener;

    public RetryPolicy<R> abortIf(Predicate<R> resultPredicate) {
        Assert.notNull(resultPredicate, "resultPredicate");
        this.abortConditions.add(RetryPolicy.resultPredicateFor(resultPredicate));
        return this;
    }

    public RetryPolicy<R> abortOn(Class<? extends Throwable> failure) {
        Assert.notNull(failure, "failure");
        return this.abortOn(Arrays.asList(failure));
    }

    public RetryPolicy<R> abortOn(List<Class<? extends Throwable>> failures) {
        Assert.notNull(failures, "failures");
        Assert.isTrue(!failures.isEmpty(), "failures cannot be empty", new Object[0]);
        this.abortConditions.add(RetryPolicy.failurePredicateFor(failures));
        return this;
    }

    public boolean allowsRetries() {
        return !(this.maxRetries != -1 && this.maxRetries <= 0 || this.maxDuration != null && this.maxDuration.toNanos() <= 0L);
    }

    public boolean isAbortable(R result, Throwable failure) {
        for (BiPredicate<R, Throwable> predicate : this.abortConditions) {
            try {
                if (!predicate.test(result, failure)) continue;
                return true;
            }
            catch (Exception exception) {
            }
        }
        return false;
    }

    public RetryPolicy<R> onFailedAttempt(CheckedConsumer<? extends ExecutionAttemptedEvent<R>> listener) {
        this.failedAttemptListener = EventListener.ofAttempt(Assert.notNull(listener, "listener"));
        return this;
    }

    public RetryPolicy<R> onRetry(CheckedConsumer<? extends ExecutionAttemptedEvent<R>> listener) {
        this.retryListener = EventListener.ofAttempt(Assert.notNull(listener, "listener"));
        return this;
    }

    public Duration getDelay() {
        return this.delay;
    }

    public Duration getDelayMin() {
        return this.delayMin;
    }

    public Duration getDelayMax() {
        return this.delayMax;
    }

    public double getDelayFactor() {
        return this.delayFactor;
    }

    public Duration getJitter() {
        return this.jitter;
    }

    public double getJitterFactor() {
        return this.jitterFactor;
    }

    public Duration getMaxDelay() {
        return this.maxDelay;
    }

    public Duration getMaxDuration() {
        return this.maxDuration;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public RetryPolicy<R> withBackoff(long delay, long maxDelay, ChronoUnit chronoUnit, double delayFactor) {
        Assert.notNull(chronoUnit, "chronoUnit");
        Assert.isTrue(delay > 0L, "The delay must be greater than 0", new Object[0]);
        Duration delayDuration = Duration.of(delay, chronoUnit);
        Duration maxDelayDuration = Duration.of(maxDelay, chronoUnit);
        Assert.state(this.maxDuration == null || delayDuration.toNanos() < this.maxDuration.toNanos(), "delay must be less than the maxDuration", new Object[0]);
        Assert.isTrue(delayDuration.toNanos() < maxDelayDuration.toNanos(), "delay must be less than the maxDelay", new Object[0]);
        Assert.isTrue(delayFactor > 1.0, "delayFactor must be greater than 1", new Object[0]);
        Assert.state(this.delay == null || this.delay.equals(Duration.ZERO), "Delays have already been set", new Object[0]);
        Assert.state(this.delayMin == null, "Random delays have already been set", new Object[0]);
        this.delay = delayDuration;
        this.maxDelay = maxDelayDuration;
        this.delayFactor = delayFactor;
        return this;
    }

    public RetryPolicy<R> withDelay(Duration delay) {
        Assert.notNull(delay, "delay");
        Assert.isTrue(delay.toNanos() > 0L, "delay must be greater than 0", new Object[0]);
        Assert.state(this.maxDuration == null || delay.toNanos() < this.maxDuration.toNanos(), "delay must be less than the maxDuration", new Object[0]);
        Assert.state(this.delayMin == null, "Random delays have already been set", new Object[0]);
        Assert.state(this.maxDelay == null, "Backoff delays have already been set", new Object[0]);
        this.delay = delay;
        return this;
    }

    public RetryPolicy<R> withJitter(double jitterFactor) {
        Assert.isTrue(jitterFactor >= 0.0 && jitterFactor <= 1.0, "jitterFactor must be >= 0 and <= 1", new Object[0]);
        Assert.state(this.jitter == null, "withJitter(Duration) has already been called", new Object[0]);
        this.jitterFactor = jitterFactor;
        return this;
    }

    public RetryPolicy<R> withMaxAttempts(int maxAttempts) {
        Assert.isTrue(maxAttempts != 0, "maxAttempts cannot be 0", new Object[0]);
        Assert.isTrue(maxAttempts >= -1, "maxAttempts cannot be less than -1", new Object[0]);
        this.maxRetries = maxAttempts == -1 ? -1 : maxAttempts - 1;
        return this;
    }

    public RetryPolicy<R> withMaxDuration(Duration maxDuration) {
        Assert.notNull(maxDuration, "maxDuration");
        Assert.state(maxDuration.toNanos() > this.delay.toNanos(), "maxDuration must be greater than the delay", new Object[0]);
        this.maxDuration = maxDuration;
        return this;
    }

    public RetryPolicy<R> withMaxRetries(int maxRetries) {
        Assert.isTrue(maxRetries >= -1, "maxRetries must be greater than or equal to -1", new Object[0]);
        this.maxRetries = maxRetries;
        return this;
    }

    @Override
    public PolicyExecutor toExecutor(AbstractExecution execution) {
        return new RetryPolicyExecutor(this, execution, this.abortListener, this.failedAttemptListener, this.retriesExceededListener, this.retryListener);
    }
}

