/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client;

import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.AbstractConnectionPool;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.ConnectionPool;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.HttpClient;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.HttpExchange;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.HttpRequest;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.Origin;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.ProxyConfiguration;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.RequestNotifier;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.ResponseNotifier;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.SendFailure;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.api.Connection;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.api.Destination;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.client.api.Response;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpField;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.http.HttpHeader;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.io.ClientConnectionFactory;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.io.CyclicTimeout;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.BlockingArrayQueue;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.Callback;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.HostPort;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.Promise;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.component.ContainerLifeCycle;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.component.DumpableCollection;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.log.Logger;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.ssl.SslContextFactory;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.thread.Scheduler;
import com.gradle.maven.extension.internal.dep.org.eclipse.jetty.util.thread.Sweeper;
import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.AsynchronousCloseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;

public abstract class HttpDestination
extends ContainerLifeCycle
implements Closeable,
Destination,
Callback {
    protected static final Logger LOG = Log.getLogger(HttpDestination.class);
    private final HttpClient client;
    private final Origin origin;
    private final Queue<HttpExchange> exchanges;
    private final RequestNotifier requestNotifier;
    private final ResponseNotifier responseNotifier;
    private final ProxyConfiguration.Proxy proxy;
    private final ClientConnectionFactory connectionFactory;
    private final HttpField hostField;
    private final RequestTimeouts requestTimeouts;
    private ConnectionPool connectionPool;

    public HttpDestination(HttpClient client, Origin origin) {
        Object tag;
        this.client = client;
        this.origin = origin;
        this.exchanges = this.newExchangeQueue(client);
        this.requestNotifier = new RequestNotifier(client);
        this.responseNotifier = new ResponseNotifier();
        this.requestTimeouts = new RequestTimeouts(client.getScheduler());
        ProxyConfiguration proxyConfig = client.getProxyConfiguration();
        this.proxy = proxyConfig.match(origin);
        ClientConnectionFactory connectionFactory = client.getTransport();
        if (this.proxy != null) {
            connectionFactory = this.proxy.newClientConnectionFactory(connectionFactory);
            if (this.proxy.isSecure()) {
                connectionFactory = this.newSslClientConnectionFactory(this.proxy.getSslContextFactory(), connectionFactory);
            }
        } else if (this.isSecure()) {
            connectionFactory = this.newSslClientConnectionFactory(null, connectionFactory);
        }
        if ((tag = origin.getTag()) instanceof ClientConnectionFactory.Decorator) {
            connectionFactory = ((ClientConnectionFactory.Decorator)tag).apply(connectionFactory);
        }
        this.connectionFactory = connectionFactory;
        String host = HostPort.normalizeHost(this.getHost());
        if (!client.isDefaultPort(this.getScheme(), this.getPort())) {
            host = host + ":" + this.getPort();
        }
        this.hostField = new HttpField(HttpHeader.HOST, host);
    }

    @Override
    protected void doStart() throws Exception {
        this.connectionPool = this.newConnectionPool(this.client);
        this.addBean(this.connectionPool, true);
        super.doStart();
        Sweeper sweeper = this.client.getBean(Sweeper.class);
        if (sweeper != null && this.connectionPool instanceof Sweeper.Sweepable) {
            sweeper.offer((Sweeper.Sweepable)((Object)this.connectionPool));
        }
    }

    @Override
    protected void doStop() throws Exception {
        Sweeper sweeper = this.client.getBean(Sweeper.class);
        if (sweeper != null && this.connectionPool instanceof Sweeper.Sweepable) {
            sweeper.remove((Sweeper.Sweepable)((Object)this.connectionPool));
        }
        super.doStop();
        this.removeBean(this.connectionPool);
    }

    protected ConnectionPool newConnectionPool(HttpClient client) {
        return client.getTransport().getConnectionPoolFactory().newConnectionPool(this);
    }

    protected Queue<HttpExchange> newExchangeQueue(HttpClient client) {
        return new BlockingArrayQueue<HttpExchange>(client.getMaxRequestsQueuedPerDestination());
    }

    @Deprecated
    protected ClientConnectionFactory newSslClientConnectionFactory(ClientConnectionFactory connectionFactory) {
        return this.client.newSslClientConnectionFactory(null, connectionFactory);
    }

    protected ClientConnectionFactory newSslClientConnectionFactory(SslContextFactory sslContextFactory, ClientConnectionFactory connectionFactory) {
        if (sslContextFactory == null) {
            return this.newSslClientConnectionFactory(connectionFactory);
        }
        return this.client.newSslClientConnectionFactory(sslContextFactory, connectionFactory);
    }

    public boolean isSecure() {
        return HttpClient.isSchemeSecure(this.getScheme());
    }

    public HttpClient getHttpClient() {
        return this.client;
    }

    public Origin getOrigin() {
        return this.origin;
    }

    public Queue<HttpExchange> getHttpExchanges() {
        return this.exchanges;
    }

    public RequestNotifier getRequestNotifier() {
        return this.requestNotifier;
    }

    public ResponseNotifier getResponseNotifier() {
        return this.responseNotifier;
    }

    public ProxyConfiguration.Proxy getProxy() {
        return this.proxy;
    }

    public ClientConnectionFactory getClientConnectionFactory() {
        return this.connectionFactory;
    }

    public String getScheme() {
        return this.origin.getScheme();
    }

    public String getHost() {
        return this.origin.getAddress().getHost();
    }

    public int getPort() {
        return this.origin.getAddress().getPort();
    }

    public int getQueuedRequestCount() {
        return this.exchanges.size();
    }

    public Origin.Address getConnectAddress() {
        return this.proxy == null ? this.origin.getAddress() : this.proxy.getAddress();
    }

    public HttpField getHostField() {
        return this.hostField;
    }

    public ConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    @Override
    public void succeeded() {
        this.send(false);
    }

    @Override
    public void failed(Throwable x2) {
        this.abort(x2);
    }

    protected void send(HttpRequest request, List<Response.ResponseListener> listeners) {
        this.send(new HttpExchange(this, request, listeners));
    }

    public void send(HttpExchange exchange) {
        HttpRequest request = exchange.getRequest();
        if (this.client.isRunning()) {
            if (this.enqueue(this.exchanges, exchange)) {
                long expiresAt = request.getTimeoutAt();
                if (expiresAt != -1L) {
                    this.requestTimeouts.schedule(expiresAt);
                }
                if (!this.client.isRunning() && this.exchanges.remove(exchange)) {
                    request.abort(new RejectedExecutionException(this.client + " is stopping"));
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Queued {} for {}", request, this);
                    }
                    this.requestNotifier.notifyQueued(request);
                    this.send();
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Max queue size {} exceeded by {} for {}", this.client.getMaxRequestsQueuedPerDestination(), request, this);
                }
                request.abort(new RejectedExecutionException("Max requests queued per destination " + this.client.getMaxRequestsQueuedPerDestination() + " exceeded for " + this));
            }
        } else {
            request.abort(new RejectedExecutionException(this.client + " is stopped"));
        }
    }

    protected boolean enqueue(Queue<HttpExchange> queue, HttpExchange exchange) {
        return queue.offer(exchange);
    }

    public void send() {
        this.send(true);
    }

    private void send(boolean create) {
        if (!this.getHttpExchanges().isEmpty()) {
            this.process(create);
        }
    }

    private void process(boolean create) {
        boolean proceed;
        Connection connection;
        while ((connection = this.connectionPool instanceof AbstractConnectionPool ? ((AbstractConnectionPool)this.connectionPool).acquire(create) : this.connectionPool.acquire()) != null && (proceed = this.process(connection))) {
            create = false;
        }
    }

    private boolean process(Connection connection) {
        HttpClient client = this.getHttpClient();
        HttpExchange exchange = this.getHttpExchanges().poll();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing exchange {} on {} of {}", exchange, connection, this);
        }
        if (exchange == null) {
            if (!this.connectionPool.release(connection)) {
                connection.close();
            }
            if (!client.isRunning()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} is stopping", client);
                }
                connection.close();
            }
            return false;
        }
        HttpRequest request = exchange.getRequest();
        Throwable cause = request.getAbortCause();
        if (cause != null) {
            boolean released;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Aborted before processing {}: {}", exchange, cause);
            }
            if (!(released = this.connectionPool.release(connection))) {
                connection.close();
            }
            exchange.abort(cause);
            return this.getQueuedRequestCount() > 0;
        }
        SendFailure failure = this.send(connection, exchange);
        if (failure == null) {
            return this.getQueuedRequestCount() > 0;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Send failed {} for {}", failure, exchange);
        }
        if (failure.retry) {
            this.send(exchange);
            return false;
        }
        request.abort(failure.failure);
        return this.getQueuedRequestCount() > 0;
    }

    protected abstract SendFailure send(Connection var1, HttpExchange var2);

    @Override
    public void newConnection(Promise<Connection> promise) {
        this.createConnection(promise);
    }

    protected void createConnection(Promise<Connection> promise) {
        this.client.newConnection(this, promise);
    }

    public boolean remove(HttpExchange exchange) {
        return this.exchanges.remove(exchange);
    }

    @Override
    public void close() {
        this.abort(new AsynchronousCloseException());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Closed {}", this);
        }
        this.connectionPool.close();
        this.requestTimeouts.destroy();
    }

    public void release(Connection connection) {
        HttpClient client;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Released {}", connection);
        }
        if ((client = this.getHttpClient()).isRunning()) {
            if (this.connectionPool.isActive(connection)) {
                if (this.connectionPool.release(connection)) {
                    this.send(false);
                } else {
                    connection.close();
                    this.send(true);
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Released explicit {}", connection);
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} is stopped", client);
            }
            connection.close();
        }
    }

    public boolean remove(Connection connection) {
        boolean removed = this.connectionPool.remove(connection);
        if (this.getHttpExchanges().isEmpty()) {
            this.tryRemoveIdleDestination();
        } else if (removed) {
            this.send(true);
        }
        return removed;
    }

    public void abort(Throwable cause) {
        for (HttpExchange exchange : new ArrayList<HttpExchange>(this.exchanges)) {
            exchange.getRequest().abort(cause);
        }
        if (this.exchanges.isEmpty()) {
            this.tryRemoveIdleDestination();
        }
    }

    private void tryRemoveIdleDestination() {
        if (this.getHttpClient().isRemoveIdleDestinations() && this.connectionPool.isEmpty()) {
            this.getHttpClient().removeDestination(this);
        }
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        this.dumpObjects(out, indent, new DumpableCollection("exchanges", this.exchanges));
    }

    public String asString() {
        return this.origin.asString();
    }

    @Override
    public String toString() {
        return String.format("%s[%s]@%x%s,queue=%d,pool=%s", HttpDestination.class.getSimpleName(), this.asString(), this.hashCode(), this.proxy == null ? "" : "(via " + this.proxy + ")", this.getQueuedRequestCount(), this.getConnectionPool());
    }

    private class RequestTimeouts
    extends CyclicTimeout {
        private final AtomicLong earliestTimeout;

        private RequestTimeouts(Scheduler scheduler) {
            super(scheduler);
            this.earliestTimeout = new AtomicLong(Long.MAX_VALUE);
        }

        @Override
        public void onTimeoutExpired() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} timeouts check", this);
            }
            long now = System.nanoTime();
            long earliest = Long.MAX_VALUE;
            this.earliestTimeout.set(earliest);
            for (HttpExchange exchange : HttpDestination.this.exchanges) {
                HttpRequest request = exchange.getRequest();
                long expiresAt = request.getTimeoutAt();
                if (expiresAt == -1L) continue;
                if (expiresAt <= now) {
                    request.abort(new TimeoutException("Total timeout " + request.getTimeout() + " ms elapsed"));
                    continue;
                }
                if (expiresAt >= earliest) continue;
                earliest = expiresAt;
            }
            if (earliest < Long.MAX_VALUE && HttpDestination.this.client.isRunning()) {
                this.schedule(earliest);
            }
        }

        private void schedule(long expiresAt) {
            long prevEarliest = this.earliestTimeout.getAndUpdate(t2 -> Math.min(t2, expiresAt));
            if (expiresAt < prevEarliest) {
                long delay = Math.max(0L, expiresAt - System.nanoTime());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} scheduling timeout in {} ms", this, TimeUnit.NANOSECONDS.toMillis(delay));
                }
                this.schedule(delay, TimeUnit.NANOSECONDS);
            }
        }
    }
}

